/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.dependencies.Category;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.Platform;
import io.quarkus.registry.model.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ComparableVersion;

public final class ImmutableRegistry
implements Registry {
    private final SortedMap<ComparableVersion, Map<String, String>> coreVersions;
    private final Set<Extension> extensions;
    private final Set<Platform> platforms;
    private final Set<Category> categories;

    private ImmutableRegistry(SortedMap<ComparableVersion, Map<String, String>> coreVersions, Set<Extension> extensions, Set<Platform> platforms, Set<Category> categories) {
        this.coreVersions = coreVersions;
        this.extensions = extensions;
        this.platforms = platforms;
        this.categories = categories;
    }

    @Override
    @JsonProperty(value="core-versions")
    public SortedMap<ComparableVersion, Map<String, String>> getCoreVersions() {
        return this.coreVersions;
    }

    @Override
    @JsonProperty(value="extensions")
    public Set<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    @JsonProperty(value="platforms")
    public Set<Platform> getPlatforms() {
        return this.platforms;
    }

    @Override
    @JsonProperty(value="categories")
    public Set<Category> getCategories() {
        return this.categories;
    }

    public final ImmutableRegistry withCoreVersions(Map<? extends ComparableVersion, ? extends Map<String, String>> entries) {
        if (this.coreVersions == entries) {
            return this;
        }
        NavigableMap<ComparableVersion, Map<String, String>> newValue = ImmutableRegistry.createUnmodifiableSortedMap(true, true, false, entries);
        return new ImmutableRegistry(newValue, this.extensions, this.platforms, this.categories);
    }

    public final ImmutableRegistry withExtensions(Extension ... elements) {
        Set<Extension> newValue = ImmutableRegistry.createUnmodifiableSet(ImmutableRegistry.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRegistry(this.coreVersions, newValue, this.platforms, this.categories);
    }

    public final ImmutableRegistry withExtensions(Iterable<? extends Extension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        Set<Extension> newValue = ImmutableRegistry.createUnmodifiableSet(ImmutableRegistry.createSafeList(elements, true, false));
        return new ImmutableRegistry(this.coreVersions, newValue, this.platforms, this.categories);
    }

    public final ImmutableRegistry withPlatforms(Platform ... elements) {
        Set<Platform> newValue = ImmutableRegistry.createUnmodifiableSet(ImmutableRegistry.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRegistry(this.coreVersions, this.extensions, newValue, this.categories);
    }

    public final ImmutableRegistry withPlatforms(Iterable<? extends Platform> elements) {
        if (this.platforms == elements) {
            return this;
        }
        Set<Platform> newValue = ImmutableRegistry.createUnmodifiableSet(ImmutableRegistry.createSafeList(elements, true, false));
        return new ImmutableRegistry(this.coreVersions, this.extensions, newValue, this.categories);
    }

    public final ImmutableRegistry withCategories(Category ... elements) {
        Set<Category> newValue = ImmutableRegistry.createUnmodifiableSet(ImmutableRegistry.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRegistry(this.coreVersions, this.extensions, this.platforms, newValue);
    }

    public final ImmutableRegistry withCategories(Iterable<? extends Category> elements) {
        if (this.categories == elements) {
            return this;
        }
        Set<Category> newValue = ImmutableRegistry.createUnmodifiableSet(ImmutableRegistry.createSafeList(elements, true, false));
        return new ImmutableRegistry(this.coreVersions, this.extensions, this.platforms, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegistry && this.equalTo((ImmutableRegistry)another);
    }

    private boolean equalTo(ImmutableRegistry another) {
        return this.coreVersions.equals(another.coreVersions) && this.extensions.equals(another.extensions) && this.platforms.equals(another.platforms) && this.categories.equals(another.categories);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coreVersions.hashCode();
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.platforms.hashCode();
        h += (h << 5) + this.categories.hashCode();
        return h;
    }

    public String toString() {
        return "Registry{coreVersions=" + this.coreVersions + ", extensions=" + this.extensions + ", platforms=" + this.platforms + ", categories=" + this.categories + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRegistry fromJson(Json json) {
        Builder builder = ImmutableRegistry.builder();
        if (json.coreVersions != null) {
            builder.putAllCoreVersions(json.coreVersions);
        }
        if (json.extensions != null) {
            builder.addAllExtensions(json.extensions);
        }
        if (json.platforms != null) {
            builder.addAllPlatforms(json.platforms);
        }
        if (json.categories != null) {
            builder.addAllCategories(json.categories);
        }
        return builder.build();
    }

    public static ImmutableRegistry copyOf(Registry instance) {
        if (instance instanceof ImmutableRegistry) {
            return (ImmutableRegistry)instance;
        }
        return ImmutableRegistry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K extends Comparable<K>, V> NavigableMap<K, V> createUnmodifiableSortedMap(boolean reverse, boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        TreeMap sortedMap;
        TreeMap<Object, V> treeMap = sortedMap = reverse ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
        if (checkNulls || skipNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                Comparable k = (Comparable)e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                sortedMap.put(k, v);
            }
        } else {
            sortedMap.putAll(map);
        }
        return Collections.unmodifiableNavigableMap(sortedMap);
    }

    public static final class Builder {
        private Map<ComparableVersion, Map<String, String>> coreVersions = new LinkedHashMap<ComparableVersion, Map<String, String>>();
        private List<Extension> extensions = new ArrayList<Extension>();
        private List<Platform> platforms = new ArrayList<Platform>();
        private List<Category> categories = new ArrayList<Category>();

        private Builder() {
        }

        public final Builder from(Registry instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCoreVersions(instance.getCoreVersions());
            this.addAllExtensions(instance.getExtensions());
            this.addAllPlatforms(instance.getPlatforms());
            this.addAllCategories(instance.getCategories());
            return this;
        }

        public final Builder putCoreVersions(ComparableVersion key, Map<String, String> value) {
            this.coreVersions.put(Objects.requireNonNull(key, "coreVersions key"), Objects.requireNonNull(value, "coreVersions value"));
            return this;
        }

        public final Builder putCoreVersions(Map.Entry<? extends ComparableVersion, ? extends Map<String, String>> entry) {
            ComparableVersion k = entry.getKey();
            Map<String, String> v = entry.getValue();
            this.coreVersions.put(Objects.requireNonNull(k, "coreVersions key"), Objects.requireNonNull(v, "coreVersions value"));
            return this;
        }

        @JsonProperty(value="core-versions")
        public final Builder coreVersions(Map<? extends ComparableVersion, ? extends Map<String, String>> entries) {
            this.coreVersions.clear();
            return this.putAllCoreVersions(entries);
        }

        public final Builder putAllCoreVersions(Map<? extends ComparableVersion, ? extends Map<String, String>> entries) {
            for (Map.Entry<? extends ComparableVersion, ? extends Map<String, String>> e : entries.entrySet()) {
                ComparableVersion k = e.getKey();
                Map<String, String> v = e.getValue();
                this.coreVersions.put(Objects.requireNonNull(k, "coreVersions key"), Objects.requireNonNull(v, "coreVersions value"));
            }
            return this;
        }

        public final Builder addExtensions(Extension element) {
            this.extensions.add(Objects.requireNonNull(element, "extensions element"));
            return this;
        }

        public final Builder addExtensions(Extension ... elements) {
            for (Extension element : elements) {
                this.extensions.add(Objects.requireNonNull(element, "extensions element"));
            }
            return this;
        }

        @JsonProperty(value="extensions")
        public final Builder extensions(Iterable<? extends Extension> elements) {
            this.extensions.clear();
            return this.addAllExtensions(elements);
        }

        public final Builder addAllExtensions(Iterable<? extends Extension> elements) {
            for (Extension extension : elements) {
                this.extensions.add(Objects.requireNonNull(extension, "extensions element"));
            }
            return this;
        }

        public final Builder addPlatforms(Platform element) {
            this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            return this;
        }

        public final Builder addPlatforms(Platform ... elements) {
            for (Platform element : elements) {
                this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            }
            return this;
        }

        @JsonProperty(value="platforms")
        public final Builder platforms(Iterable<? extends Platform> elements) {
            this.platforms.clear();
            return this.addAllPlatforms(elements);
        }

        public final Builder addAllPlatforms(Iterable<? extends Platform> elements) {
            for (Platform platform : elements) {
                this.platforms.add(Objects.requireNonNull(platform, "platforms element"));
            }
            return this;
        }

        public final Builder addCategories(Category element) {
            this.categories.add(Objects.requireNonNull(element, "categories element"));
            return this;
        }

        public final Builder addCategories(Category ... elements) {
            for (Category element : elements) {
                this.categories.add(Objects.requireNonNull(element, "categories element"));
            }
            return this;
        }

        @JsonProperty(value="categories")
        public final Builder categories(Iterable<? extends Category> elements) {
            this.categories.clear();
            return this.addAllCategories(elements);
        }

        public final Builder addAllCategories(Iterable<? extends Category> elements) {
            for (Category category : elements) {
                this.categories.add(Objects.requireNonNull(category, "categories element"));
            }
            return this;
        }

        public ImmutableRegistry build() {
            return new ImmutableRegistry(ImmutableRegistry.createUnmodifiableSortedMap(true, false, false, this.coreVersions), ImmutableRegistry.createUnmodifiableSet(this.extensions), ImmutableRegistry.createUnmodifiableSet(this.platforms), ImmutableRegistry.createUnmodifiableSet(this.categories));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Registry {
        SortedMap<ComparableVersion, Map<String, String>> coreVersions = ImmutableRegistry.access$000(true, false, false, Collections.emptyMap());
        Set<Extension> extensions = Collections.emptySet();
        Set<Platform> platforms = Collections.emptySet();
        Set<Category> categories = Collections.emptySet();

        Json() {
        }

        @JsonProperty(value="core-versions")
        public void setCoreVersions(SortedMap<ComparableVersion, Map<String, String>> coreVersions) {
            this.coreVersions = coreVersions;
        }

        @JsonProperty(value="extensions")
        public void setExtensions(Set<Extension> extensions) {
            this.extensions = extensions;
        }

        @JsonProperty(value="platforms")
        public void setPlatforms(Set<Platform> platforms) {
            this.platforms = platforms;
        }

        @JsonProperty(value="categories")
        public void setCategories(Set<Category> categories) {
            this.categories = categories;
        }

        @Override
        public SortedMap<ComparableVersion, Map<String, String>> getCoreVersions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Extension> getExtensions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Platform> getPlatforms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Category> getCategories() {
            throw new UnsupportedOperationException();
        }
    }
}

