/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.MavenBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.nio.file.Path;
import java.util.Objects;

public final class QuarkusProject {
    private final Path projectDirPath;
    private final QuarkusPlatformDescriptor platformDescriptor;
    private final ExtensionManager extensionManager;

    private QuarkusProject(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor, ExtensionManager extensionManager) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectDirPath is required");
        this.platformDescriptor = Objects.requireNonNull(platformDescriptor, "platformDescriptor is required");
        this.extensionManager = Objects.requireNonNull(extensionManager, "extensionManager is required");
    }

    public static QuarkusProject of(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor, ExtensionManager extensionManager) {
        return new QuarkusProject(projectDirPath, platformDescriptor, extensionManager);
    }

    public static QuarkusProject of(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor, BuildTool buildTool) {
        return new QuarkusProject(projectDirPath, platformDescriptor, buildTool.createExtensionManager(projectDirPath, platformDescriptor));
    }

    public static QuarkusProject maven(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor) {
        return new QuarkusProject(projectDirPath, platformDescriptor, new MavenBuildFile(projectDirPath, platformDescriptor));
    }

    public static QuarkusProject resolveExistingProject(Path projectDirPath, QuarkusPlatformDescriptor descriptor) {
        BuildTool buildTool = QuarkusProject.resolveExistingProjectBuildTool(projectDirPath);
        if (buildTool == null) {
            throw new IllegalStateException("This is neither a Maven or Gradle project");
        }
        return QuarkusProject.of(projectDirPath, descriptor, buildTool);
    }

    public Path getProjectDirPath() {
        return this.projectDirPath;
    }

    public BuildTool getBuildTool() {
        return this.extensionManager.getBuildTool();
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public QuarkusPlatformDescriptor getPlatformDescriptor() {
        return this.platformDescriptor;
    }

    public static BuildTool resolveExistingProjectBuildTool(Path projectDirPath) {
        if (projectDirPath.resolve("pom.xml").toFile().exists()) {
            return BuildTool.MAVEN;
        }
        if (projectDirPath.resolve("build.gradle").toFile().exists()) {
            return BuildTool.GRADLE;
        }
        if (projectDirPath.resolve("build.gradle.kts").toFile().exists()) {
            return BuildTool.GRADLE_KOTLIN_DSL;
        }
        return null;
    }
}

