/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFilesCreator;
import io.quarkus.devtools.project.buildfile.GroovyGradleBuildFilesCreator;
import io.quarkus.devtools.project.buildfile.KotlinGradleBuildFilesCreator;
import io.quarkus.devtools.project.codegen.ProjectGeneratorRegistry;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;

public class LegacyCreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        QuarkusPlatformDescriptor platformDescr = invocation.getPlatformDescriptor();
        invocation.setValue("bom_groupId", platformDescr.getBomGroupId());
        invocation.setValue("bom_artifactId", platformDescr.getBomArtifactId());
        invocation.setValue("quarkus_version", platformDescr.getQuarkusVersion());
        invocation.setValue("bom_version", platformDescr.getBomVersion());
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(platformDescr);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace("-", "_");
            if (!invocation.hasValue(name)) {
                invocation.setValue(k.toString().replace("-", "_"), v.toString());
            }
        }));
        LegacyCreateProjectCommandHandler.addPlatformDataToLegacyCodegen(invocation);
        try {
            List<AppArtifactCoords> extensionsToAdd;
            String className = invocation.getStringValue("class_name");
            if (className != null) {
                className = invocation.getValue("source_type", SourceType.JAVA).stripExtensionFrom(className);
                int idx = className.lastIndexOf(46);
                if (idx >= 0) {
                    String pkgName = invocation.getStringValue("package_name");
                    if (pkgName == null) {
                        invocation.setValue("package_name", className.substring(0, idx));
                    }
                    className = className.substring(idx + 1);
                }
                invocation.setValue("class_name", className);
            }
            if ((extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery)) != null) {
                AbstractGradleBuildFilesCreator generator;
                ProjectGeneratorRegistry.get("basic-rest").generate(invocation);
                if (invocation.getQuarkusProject().getBuildTool().equals((Object)BuildTool.GRADLE)) {
                    generator = new GroovyGradleBuildFilesCreator(invocation.getQuarkusProject());
                    ((GroovyGradleBuildFilesCreator)generator).create(invocation.getStringValue("project_groupId"), invocation.getStringValue("project_artifactId"), invocation.getStringValue("project_version"), quarkusProps, (List)extensionsToAdd);
                } else if (invocation.getQuarkusProject().getBuildTool().equals((Object)BuildTool.GRADLE_KOTLIN_DSL)) {
                    generator = new KotlinGradleBuildFilesCreator(invocation.getQuarkusProject());
                    ((KotlinGradleBuildFilesCreator)generator).create(invocation.getStringValue("project_groupId"), invocation.getStringValue("project_artifactId"), invocation.getStringValue("project_version"), quarkusProps, (List)extensionsToAdd);
                } else {
                    ExtensionManager.InstallResult result = invocation.getQuarkusProject().getExtensionManager().install(extensionsToAdd);
                    result.getInstalled().forEach(a -> invocation.log().info("\u2705 Extension " + a.getGroupId() + ":" + a.getArtifactId() + " has been installed"));
                }
            }
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to create project", e);
        }
        return QuarkusCommandOutcome.success();
    }

    static void addPlatformDataToLegacyCodegen(QuarkusCommandInvocation invocation) {
        BuildTool buildTool = invocation.getQuarkusProject().getBuildTool();
        if (BuildTool.MAVEN == buildTool) {
            Map repo;
            Optional mavenPluginRepositories;
            Map repo2;
            Optional mavenRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"maven.repositories");
            if (mavenRepositories.isPresent() && !((List)mavenRepositories.get()).isEmpty() && (repo2 = (Map)((List)mavenRepositories.get()).get(0)) != null && repo2.get("id") instanceof String && repo2.get("url") instanceof String) {
                StringBuilder repositories = new StringBuilder().append("\n").append("    <repositories>\n").append("        <repository>\n").append("            <id>").append(repo2.get("id")).append("</id>\n").append("            <url>").append(repo2.get("url")).append("</url>\n").append("            <releases>\n").append("                <enabled>").append(repo2.getOrDefault("releases-enabled", true)).append("</enabled>\n").append("            </releases>\n").append("            <snapshots>\n").append("                <enabled>").append(repo2.getOrDefault("snapshots-enabled", true)).append("</enabled>\n").append("            </snapshots>\n").append("        </repository>\n").append("    </repositories>\n");
                invocation.setValue("maven_repositories", repositories.toString());
            }
            if ((mavenPluginRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"maven.plugin-repositories")).isPresent() && !((List)mavenPluginRepositories.get()).isEmpty() && (repo = (Map)((List)mavenPluginRepositories.get()).get(0)) != null && repo.get("id") instanceof String && repo.get("url") instanceof String) {
                StringBuilder pluginRepositories = new StringBuilder().append("\n").append("    <pluginRepositories>\n").append("        <pluginRepository>\n").append("            <id>").append(repo.get("id")).append("</id>\n").append("            <url>").append(repo.get("url")).append("</url>\n").append("            <releases>\n").append("                <enabled>").append(repo.getOrDefault("releases-enabled", true)).append("</enabled>\n").append("            </releases>\n").append("            <snapshots>\n").append("                <enabled>").append(repo.getOrDefault("snapshots-enabled", true)).append("</enabled>\n").append("            </snapshots>\n").append("        </pluginRepository>\n").append("    </pluginRepositories>\n");
                invocation.setValue("maven_plugin_repositories", pluginRepositories.toString());
            }
        } else if (BuildTool.GRADLE == buildTool || BuildTool.GRADLE_KOTLIN_DSL == buildTool) {
            Map repo;
            Optional gradlePluginRepositories;
            Map repo3;
            Optional gradleRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"gradle.repositories");
            if (gradleRepositories.isPresent() && !((List)gradleRepositories.get()).isEmpty() && (repo3 = (Map)((List)gradleRepositories.get()).get(0)) != null && repo3.get("url") instanceof String) {
                String repositories = buildTool == BuildTool.GRADLE ? "\n     maven { url \"" + repo3.get("url") + "\" }" : "\n     maven { url = uri(\"" + repo3.get("url") + "\") }";
                invocation.setValue("maven_repositories", repositories);
            }
            if ((gradlePluginRepositories = NestedMaps.getValue((Map)invocation.getPlatformDescriptor().getMetadata(), (String)"gradle.plugin-repositories")).isPresent() && !((List)gradlePluginRepositories.get()).isEmpty() && (repo = (Map)((List)gradlePluginRepositories.get()).get(0)) != null && repo.get("url") instanceof String) {
                String pluginRepositories = buildTool == BuildTool.GRADLE ? "\n     maven { url \"" + repo.get("url") + "\" }" : "\n     maven { url = uri(\"" + repo.get("url") + "\") }";
                invocation.setValue("maven_plugin_repositories", pluginRepositories);
            }
        }
    }
}

