/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.generators;

import java.util.Arrays;
import java.util.Optional;

public enum SourceType {
    JAVA(".java", "java"),
    KOTLIN(".kt", "kotlin"),
    SCALA(".scala", "scala");

    private static final String srcDirPrefix = "src/main/";
    private static final String testSrcDirPrefix = "src/test/";
    private static final String BUILD_FILE_RESOURCE_TEMPLATE = "templates/%s/%s/%s-template.ftl";
    private static final String RESOURCE_TEMPLATE = "templates/%s/%s/resource-template.ftl";
    private static final String SPRING_CONTROLLER_TEMPLATE = "templates/%s/%s/spring-controller-template.ftl";
    private static final String TEST_RESOURCE_TEMPLATE = "templates/%s/%s/test-resource-template.ftl";
    private static final String NATIVE_TEST_RESOURCE_TEMPLATE = "templates/%s/%s/native-test-resource-template.ftl";
    private final String extension;
    private final String name;

    private SourceType(String extension, String name) {
        this.extension = extension;
        this.name = name;
    }

    public String getSrcDir() {
        return srcDirPrefix + this.getPathDiscriminator();
    }

    private String getPathDiscriminator() {
        return this.name;
    }

    public String getTestSrcDir() {
        return testSrcDirPrefix + this.getPathDiscriminator();
    }

    public String getBuildFileResourceTemplate(String templateName, String buildFile) {
        return this.computeTemplateFile(BUILD_FILE_RESOURCE_TEMPLATE, templateName, buildFile);
    }

    public String getSrcResourceTemplate(String templateName) {
        return this.computeTemplateFile(RESOURCE_TEMPLATE, templateName);
    }

    public String getSrcSpringControllerTemplate(String templateName) {
        return this.computeTemplateFile(SPRING_CONTROLLER_TEMPLATE, templateName);
    }

    public String getTestResourceTemplate(String templateName) {
        return this.computeTemplateFile(TEST_RESOURCE_TEMPLATE, templateName);
    }

    public String getNativeTestResourceTemplate(String templateName) {
        return this.computeTemplateFile(NATIVE_TEST_RESOURCE_TEMPLATE, templateName);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public String stripExtensionFrom(String className) {
        if (className != null && className.endsWith(this.extension)) {
            return className.substring(0, className.length() - this.extension.length());
        }
        return className;
    }

    private String computeTemplateFile(String genericTemplate, String templateName) {
        return this.computeTemplateFile(genericTemplate, templateName, null);
    }

    private String computeTemplateFile(String genericTemplate, String templateName, String fileName) {
        return String.format(genericTemplate, templateName, this.getPathDiscriminator(), fileName);
    }

    public static Optional<SourceType> parse(String extension) {
        return Arrays.stream(SourceType.values()).filter(e -> extension.contains(e.name)).findAny();
    }
}

