/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class ContentMergeCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    static final String NAME = "content-merge";

    ContentMergeCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        Optional<Object> template = Optional.empty();
        StringBuilder mergedContent = new StringBuilder();
        for (TargetFile f : codestartFiles) {
            if (f.getContent().contains("{merged-content}")) {
                if (template.isPresent()) {
                    throw new CodestartStructureException("Found more than one file containing '{merged-content}': " + f.getSourceName() + ", " + ((TargetFile)template.get()).getSourceName());
                }
                template = Optional.of(f);
                continue;
            }
            mergedContent.append(f.getContent());
        }
        if (!template.isPresent() || mergedContent.length() == 0) {
            return;
        }
        this.createDirectories(targetPath);
        this.writeFile(targetPath, ((TargetFile)template.get()).getContent().replace("{merged-content}", mergedContent.toString()));
    }
}

