/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.core.CodestartData;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class SmartConfigMergeCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false));
    private static final String APP_CONFIG = "app-config";

    SmartConfigMergeCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "smart-config-merge";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        String configType = SmartConfigMergeCodestartFileStrategyHandler.getConfigType(data);
        Map<String, Object> config = this.initConfigMap(data);
        for (TargetFile codestartFile : codestartFiles) {
            String content = codestartFile.getContent();
            if (content.trim().isEmpty()) continue;
            Map o = (Map)YAML_MAPPER.readerFor(Map.class).readValue(content);
            config.putAll(NestedMaps.deepMerge(config, o));
        }
        Path targetPath = targetDirectory.resolve(relativePath);
        this.createDirectories(targetPath);
        if (Objects.equals(configType, "config-properties")) {
            this.writePropertiesConfig(targetPath, config);
            return;
        }
        if (Objects.equals(configType, "config-yaml")) {
            this.writeYamlConfig(targetPath, config);
            return;
        }
        throw new CodestartException("Unsupported config type: " + configType);
    }

    private void writeYamlConfig(Path targetPath, Map<String, Object> config) throws IOException {
        this.checkTargetDoesNotExist(targetPath);
        YAML_MAPPER.writerFor(Map.class).writeValue(targetPath.toFile(), config);
    }

    private void writePropertiesConfig(Path targetPath, Map<String, Object> config) throws IOException {
        StringBuilder builder = new StringBuilder();
        HashMap<String, String> flat = new HashMap<String, String>();
        SmartConfigMergeCodestartFileStrategyHandler.flatten("", flat, config);
        for (Map.Entry<String, String> entry : flat.entrySet()) {
            String key = entry.getKey().replaceAll("\\.~$", "");
            builder.append(key).append("=").append(entry.getValue()).append("\n");
        }
        Path propertiesTargetPath = targetPath.getParent().resolve(targetPath.getFileName().toString().replace(".yml", ".properties"));
        this.checkTargetDoesNotExist(propertiesTargetPath);
        this.writeFile(propertiesTargetPath, builder.toString());
    }

    static void flatten(String prefix, Map<String, String> target, Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                SmartConfigMergeCodestartFileStrategyHandler.flatten(prefix + SmartConfigMergeCodestartFileStrategyHandler.quote(entry.getKey().toString()) + ".", target, (Map)entry.getValue());
                continue;
            }
            target.put(prefix + SmartConfigMergeCodestartFileStrategyHandler.quote(entry.getKey().toString()), entry.getValue().toString());
        }
    }

    private static String quote(String key) {
        if (!key.contains(".")) {
            return key;
        }
        return "\"" + key.replaceAll("\"", "\\\"") + "\"";
    }

    private static String getConfigType(Map<String, Object> data) {
        Optional<String> config = CodestartData.getInputCodestartForType(data, CodestartType.CONFIG);
        return config.orElseThrow(() -> new CodestartException("Config type is required"));
    }

    private Map<String, Object> initConfigMap(Map<String, Object> data) {
        if (data.get(APP_CONFIG) instanceof Map) {
            return NestedMaps.unflatten((Map)data.get(APP_CONFIG));
        }
        return new HashMap<String, Object>();
    }
}

