/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class AppendCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    AppendCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "append";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<CodestartFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        this.checkTargetDoesNotExist(targetPath);
        this.createDirectories(targetPath);
        String content = codestartFiles.stream().map(CodestartFile::getContent).collect(Collectors.joining("\n"));
        Files.write(targetPath, content.getBytes(), new OpenOption[0]);
    }
}

