/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mssql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.DatasourceServiceConfigurator;

public class MSSQLDatasourceServiceConfigurator
implements DatasourceServiceConfigurator {
    private static final String[] PASSWORD_ENVS = new String[]{"MSSQL_SA_PASSWORD", "SA_PASSWORD", "MSSQL_PASSWORD"};
    private static final String DEFAULT_MSSQL_USERNAME = "sa";

    public DevServicesDatasourceProvider.RunningDevServicesDatasource composeRunningService(ContainerAddress containerAddress, DevServicesDatasourceContainerConfig containerConfig) {
        RunningContainer container = containerAddress.getRunningContainer();
        String effectiveUsername = containerConfig.getUsername().orElse(DEFAULT_MSSQL_USERNAME);
        String effectivePassword = containerConfig.getPassword().orElse("quarkus");
        String jdbcUrl = this.getJdbcUrl(containerAddress, null);
        String reactiveUrl = this.getReactiveUrl(jdbcUrl);
        return new DevServicesDatasourceProvider.RunningDevServicesDatasource(containerAddress.getId(), jdbcUrl, reactiveUrl, effectiveUsername, container.tryGetEnv(PASSWORD_ENVS).orElse(effectivePassword), null);
    }

    public String getJdbcPrefix() {
        return "sqlserver";
    }

    public String getParametersStartCharacter() {
        return ";";
    }

    public String getJdbcUrl(ContainerAddress containerAddress, String databaseName) {
        return String.format("jdbc:%s://%s:%d%s", this.getJdbcPrefix(), containerAddress.getHost(), containerAddress.getPort(), this.getParameters(containerAddress.getRunningContainer().containerInfo().labels()));
    }
}

