/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.h2.deployment;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.h2.tools.Server;
import org.jboss.logging.Logger;

public class H2DevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(H2DevServicesProcessor.class);

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupH2() {
        return new DevServicesDatasourceProviderBuildItem("h2", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, String datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                try {
                    final Server tcpServer = Server.createTcpServer((String[])new String[]{"-tcpPort", containerConfig.getFixedExposedPort().isPresent() ? String.valueOf(containerConfig.getFixedExposedPort().getAsInt()) : "0", "-ifNotExists"});
                    tcpServer.start();
                    final String effectiveUsername = containerConfig.getUsername().orElse(username.orElse("quarkus"));
                    final String effectivePassword = containerConfig.getPassword().orElse(password.orElse("quarkus"));
                    String effectiveDbName = containerConfig.getDbName().orElse(DataSourceUtil.isDefault((String)datasourceName) ? "quarkus" : datasourceName);
                    StringBuilder additionalArgs = new StringBuilder();
                    for (Map.Entry i : containerConfig.getAdditionalJdbcUrlProperties().entrySet()) {
                        additionalArgs.append(";");
                        additionalArgs.append((String)i.getKey());
                        additionalArgs.append("=");
                        additionalArgs.append((String)i.getValue());
                    }
                    LOG.info((Object)"Dev Services for H2 started.");
                    final String connectionUrl = "jdbc:h2:tcp://localhost:" + tcpServer.getPort() + "/mem:" + effectiveDbName + ";DB_CLOSE_DELAY=-1" + additionalArgs.toString();
                    return new DevServicesDatasourceProvider.RunningDevServicesDatasource(null, connectionUrl, null, effectiveUsername, effectivePassword, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            if (tcpServer.isRunning(false)) {
                                try (Connection connection = DriverManager.getConnection(connectionUrl, effectiveUsername, effectivePassword);
                                     Statement statement = connection.createStatement();){
                                    statement.execute("SET DB_CLOSE_DELAY 0");
                                }
                                catch (SQLException t) {
                                    t.printStackTrace();
                                }
                                tcpServer.stop();
                                LOG.info((Object)("Dev Services for H2 shut down; server status: " + tcpServer.getStatus()));
                            } else {
                                LOG.info((Object)("Dev Services for H2 was NOT shut down as it appears it was down already; server status: " + tcpServer.getStatus()));
                            }
                        }
                    });
                }
                catch (SQLException throwables) {
                    throw new RuntimeException(throwables);
                }
            }

            public boolean isDockerRequired() {
                return false;
            }
        });
    }
}

