/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.common.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class DatabaseKind {
    public static final String DB2 = "db2";
    public static final String DERBY = "derby";
    public static final String H2 = "h2";
    public static final String MARIADB = "mariadb";
    public static final String MSSQL = "mssql";
    public static final String MYSQL = "mysql";
    public static final String POSTGRESQL = "postgresql";
    public static final String ORACLE = "oracle";
    private static final Map<String, String> ALIASES;

    public static String normalize(String value) {
        if (value == null) {
            return null;
        }
        String lowerCaseValue = value.toLowerCase(Locale.ROOT).trim();
        if (lowerCaseValue.isEmpty()) {
            return null;
        }
        String supportedValue = ALIASES.get(lowerCaseValue);
        if (supportedValue != null) {
            return supportedValue;
        }
        return lowerCaseValue;
    }

    public static boolean isDB2(String value) {
        return DatabaseKind.is(value, DB2);
    }

    public static boolean isDerby(String value) {
        return DatabaseKind.is(value, DERBY);
    }

    public static boolean isH2(String value) {
        return DatabaseKind.is(value, H2);
    }

    public static boolean isMariaDB(String value) {
        return DatabaseKind.is(value, MARIADB);
    }

    public static boolean isMsSQL(String value) {
        return DatabaseKind.is(value, MSSQL);
    }

    public static boolean isMySQL(String value) {
        return DatabaseKind.is(value, MYSQL);
    }

    public static boolean isOracle(String value) {
        return DatabaseKind.is(value, ORACLE);
    }

    public static boolean isPostgreSQL(String value) {
        return DatabaseKind.is(value, POSTGRESQL);
    }

    private static boolean is(String value, String mainName) {
        if (value == null) {
            return false;
        }
        String normalizedValue = DatabaseKind.normalize(value);
        return mainName.equals(normalizedValue);
    }

    private DatabaseKind() {
    }

    static {
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (SupportedDatabaseKind kind : SupportedDatabaseKind.values()) {
            for (String alias : kind.aliases) {
                aliases.put(alias.toLowerCase(Locale.ROOT), kind.mainName.toLowerCase(Locale.ROOT));
            }
        }
        ALIASES = Collections.unmodifiableMap(aliases);
    }

    private static enum SupportedDatabaseKind {
        DB2("db2"),
        DERBY("derby"),
        H2("h2"),
        MARIADB("mariadb"),
        MSSQL("mssql"),
        MYSQL("mysql"),
        ORACLE("oracle"),
        POSTGRESQL("postgresql", "pgsql", "pg");

        private final String mainName;
        private final Set<String> aliases;

        private SupportedDatabaseKind(String mainName) {
            this.mainName = mainName;
            this.aliases = Collections.singleton(mainName);
        }

        private SupportedDatabaseKind(String mainName, String ... aliases) {
            this.mainName = mainName;
            this.aliases = new HashSet<String>();
            this.aliases.add(mainName);
            this.aliases.addAll(Arrays.asList(aliases));
        }
    }
}

