/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.util.IoUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.TypeArgument;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class AnnotationProxyProvider {
    private final ConcurrentMap<DotName, String> annotationLiterals = new ConcurrentHashMap<DotName, String>();
    private final ConcurrentMap<DotName, ClassInfo> annotationClasses = new ConcurrentHashMap<DotName, ClassInfo>();
    private final ConcurrentMap<String, Boolean> generatedLiterals = new ConcurrentHashMap<String, Boolean>();
    private final ClassLoader classLoader;
    private final IndexView index;

    AnnotationProxyProvider(IndexView index) {
        this.index = index;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = AnnotationProxy.class.getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public <A extends Annotation> AnnotationProxyBuilder<A> builder(AnnotationInstance annotationInstance, Class<A> annotationType) {
        if (!annotationInstance.name().toString().equals(annotationType.getName())) {
            throw new IllegalArgumentException("Annotation instance " + String.valueOf(annotationInstance) + " does not match annotation type " + annotationType.getName());
        }
        ClassInfo annotationClass = this.annotationClasses.computeIfAbsent(annotationInstance.name(), name -> {
            ClassInfo clazz = this.index.getClassByName(name);
            if (clazz == null) {
                try (InputStream annotationStream = IoUtil.readClass(this.classLoader, name.toString());){
                    clazz = Index.singleClass((InputStream)annotationStream);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to index: " + String.valueOf(name), e);
                }
            }
            return clazz;
        });
        String annotationLiteral = this.annotationLiterals.computeIfAbsent(annotationInstance.name(), name -> String.valueOf(name) + "_Proxy_AnnotationLiteral");
        return new AnnotationProxyBuilder<A>(annotationInstance, annotationType, annotationLiteral, annotationClass);
    }

    public static interface AnnotationProxy {
        public String getAnnotationLiteralType();

        public ClassInfo getAnnotationClass();

        public AnnotationInstance getAnnotationInstance();

        public Map<String, Object> getDefaultValues();

        public Map<String, Object> getValues();
    }

    public class AnnotationProxyBuilder<A> {
        private final ClassInfo annotationClass;
        private final String annotationLiteral;
        private final AnnotationInstance annotationInstance;
        private final Class<A> annotationType;
        private final Map<String, Object> defaultValues = new HashMap<String, Object>();
        private final Map<String, Object> values = new HashMap<String, Object>();

        AnnotationProxyBuilder(AnnotationInstance annotationInstance, Class<A> annotationType, String annotationLiteral, ClassInfo annotationClass) {
            this.annotationInstance = annotationInstance;
            this.annotationType = annotationType;
            this.annotationLiteral = annotationLiteral;
            this.annotationClass = annotationClass;
        }

        public AnnotationProxyBuilder<A> withValue(String name, Object value) {
            this.values.put(name, value);
            return this;
        }

        public AnnotationProxyBuilder<A> withDefaultValue(String name, Object value) {
            if (this.annotationInstance.value(name) == null) {
                this.defaultValues.put(name, value);
            }
            return this;
        }

        public A build(io.quarkus.gizmo.ClassOutput classOutput) {
            AnnotationProxyProvider.this.generatedLiterals.computeIfAbsent(this.annotationLiteral, generatedName -> {
                String name = this.annotationInstance.name().toString();
                String signature = String.format("L%1$s<L%2$s;>;L%2$s;", AnnotationLiteral.class.getName().replace('.', '/'), name.replace('.', '/'));
                ClassCreator literal = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AnnotationLiteral.class).interfaces(new String[]{name}).signature(signature).build();
                List constructorParams = this.annotationClass.methods().stream().filter(m -> !m.name().equals("<clinit>") && !m.name().equals("<init>")).collect(Collectors.toList());
                MethodCreator constructor = literal.getMethodCreator("<init>", (Object)"V", constructorParams.stream().map(m -> m.returnType().name().toString()).toArray());
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                ListIterator iterator = constructorParams.listIterator();
                while (iterator.hasNext()) {
                    MethodInfo param = (MethodInfo)iterator.next();
                    String returnType = param.returnType().name().toString();
                    literal.getFieldCreator(param.name(), returnType).setModifiers(18);
                    constructor.writeInstanceField(FieldDescriptor.of((String)literal.getClassName(), (String)param.name(), (String)returnType), constructor.getThis(), constructor.getMethodParam(iterator.previousIndex()));
                    MethodCreator value = (MethodCreator)literal.getMethodCreator(param.name(), returnType, new String[0]).setModifiers(1);
                    value.returnValue(value.readInstanceField(FieldDescriptor.of((String)literal.getClassName(), (String)param.name(), (String)returnType), value.getThis()));
                }
                constructor.returnValue(null);
                literal.close();
                return Boolean.TRUE;
            });
            return this.proxy();
        }

        private A proxy() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = AnnotationProxy.class.getClassLoader();
            }
            return (A)Proxy.newProxyInstance(classLoader, new Class[]{this.annotationType, AnnotationProxy.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String name;
                    return switch (name = method.getName()) {
                        case "getAnnotationLiteralType" -> AnnotationProxyBuilder.this.annotationLiteral;
                        case "getAnnotationClass" -> AnnotationProxyBuilder.this.annotationClass;
                        case "getAnnotationInstance" -> AnnotationProxyBuilder.this.annotationInstance;
                        case "getDefaultValues" -> AnnotationProxyBuilder.this.defaultValues;
                        case "getValues" -> AnnotationProxyBuilder.this.values;
                        default -> {
                            MethodInfo member = AnnotationProxyBuilder.this.annotationClass.firstMethod(name);
                            if (member != null) {
                                if (AnnotationProxyBuilder.this.values.containsKey(name)) {
                                    yield AnnotationProxyBuilder.this.values.get(name);
                                }
                                if (AnnotationProxyBuilder.this.annotationInstance.value(name) != null) {
                                    yield AnnotationProxyBuilder.this.annotationInstance.value(name).value();
                                }
                                if (AnnotationProxyBuilder.this.defaultValues.containsKey(name)) {
                                    yield AnnotationProxyBuilder.this.defaultValues.get(name);
                                }
                                if (member.defaultValue() != null) {
                                    yield member.defaultValue().value();
                                }
                                throw new UnsupportedOperationException("Unknown value of annotation member " + name);
                            }
                            throw new UnsupportedOperationException("Method " + String.valueOf(method) + " not implemented");
                        }
                    };
                }
            });
        }

        public A build(ClassOutput classOutput) {
            AnnotationProxyProvider.this.generatedLiterals.computeIfAbsent(this.annotationLiteral, generatedName -> {
                Gizmo gizmo = Gizmo.create((ClassOutput)classOutput).withDebugInfo(false).withParameters(false);
                gizmo.class_(generatedName, cc -> {
                    ClassDesc annotationClassDesc = Jandex2Gizmo.classDescOf((DotName)this.annotationInstance.name());
                    cc.extends_(GenericType.ofClass(AnnotationLiteral.class, (TypeArgument[])new TypeArgument[]{TypeArgument.of((ClassDesc)annotationClassDesc)}));
                    cc.implements_(annotationClassDesc);
                    List<MethodInfo> members = this.annotationClass.methods().stream().filter(m -> !m.isStaticInitializer() && !m.isConstructor()).toList();
                    ArrayList<FieldDesc> fields = new ArrayList<FieldDesc>(members.size());
                    for (MethodInfo member : members) {
                        fields.add(cc.field(member.name(), fc -> {
                            fc.private_();
                            fc.final_();
                            fc.setType(Jandex2Gizmo.classDescOf((Type)member.returnType()));
                        }));
                    }
                    cc.constructor(mc -> {
                        ArrayList<ParamVar> params = new ArrayList<ParamVar>(members.size());
                        for (MethodInfo member : members) {
                            params.add(mc.parameter(member.name(), Jandex2Gizmo.classDescOf((Type)member.returnType())));
                        }
                        mc.body(bc -> {
                            bc.invokeSpecial(ConstructorDesc.of(AnnotationLiteral.class, (Class[])new Class[0]), (Expr)cc.this_());
                            for (int i = 0; i < members.size(); ++i) {
                                bc.set((Assignable)cc.this_().field((FieldDesc)fields.get(i)), (Expr)params.get(i));
                            }
                            bc.return_();
                        });
                    });
                    for (int i = 0; i < members.size(); ++i) {
                        MethodInfo member;
                        member = members.get(i);
                        FieldDesc field = (FieldDesc)fields.get(i);
                        cc.method(member.name(), mc -> {
                            mc.returning(Jandex2Gizmo.classDescOf((Type)member.returnType()));
                            mc.body(bc -> bc.return_((Expr)cc.this_().field(field)));
                        });
                    }
                });
                return Boolean.TRUE;
            });
            return this.proxy();
        }
    }
}

