/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

public class CompiledJavaVersionBuildStep {
    private static final Logger log = Logger.getLogger(CompiledJavaVersionBuildStep.class);

    @BuildStep
    public CompiledJavaVersionBuildItem compiledJavaVersion(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        ResolvedDependency appArtifact = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        Integer majorVersion = CompiledJavaVersionBuildStep.getMajorJavaVersion(appArtifact);
        if (majorVersion == null) {
            ResolvedDependency module;
            Iterator iterator = curateOutcomeBuildItem.getApplicationModel().getDependencies(32).iterator();
            while (iterator.hasNext() && (majorVersion = CompiledJavaVersionBuildStep.getMajorJavaVersion(module = (ResolvedDependency)iterator.next())) == null) {
            }
        }
        if (majorVersion == null) {
            log.debug((Object)"No .class files located");
            return CompiledJavaVersionBuildItem.unknown();
        }
        return CompiledJavaVersionBuildItem.fromMajorJavaVersion(majorVersion);
    }

    private static Integer getMajorJavaVersion(ResolvedDependency artifact) {
        AtomicReference<Object> majorVersion = new AtomicReference<Object>(null);
        artifact.getContentTree().walk(visit -> {
            Path file = visit.getPath();
            if (file.getFileName() == null) {
                return;
            }
            if (file.getFileName().toString().endsWith(".class") && !Files.isDirectory(file, new LinkOption[0])) {
                log.debugf("Checking file '%s'", (Object)file.toAbsolutePath().toString());
                try (DataInputStream data = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                    if (-889275714 == data.readInt()) {
                        data.readUnsignedShort();
                        int v = data.readUnsignedShort();
                        majorVersion.set(v);
                        log.debugf("Determined compile java version to be %d", v);
                        visit.stopWalking();
                    }
                }
                catch (IOException e) {
                    log.debugf((Throwable)e, "Encountered exception while processing file '%s'", (Object)file.toAbsolutePath().toString());
                }
            }
        });
        return majorVersion.get();
    }
}

