/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class IDEDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger((String)IDEDevModeMain.class.getName());
    private static final String APP_PROJECT = "app-project";
    private IsolatedDevModeMain delegate;

    @Override
    public void accept(CuratedApplication curatedApplication, Map<String, Object> stringObjectMap) {
        Path appClasses = (Path)stringObjectMap.get("app-classes");
        DevModeContext devModeContext = new DevModeContext();
        devModeContext.setArgs((String[])stringObjectMap.get("args"));
        ApplicationModel appModel = null;
        try {
            appModel = BuildToolHelper.isMavenProject((Path)appClasses) ? curatedApplication.getApplicationModel() : BootstrapUtils.deserializeQuarkusModel((Path)((Path)stringObjectMap.get("quarkus-internal.serialized-app-model.path")));
            if (appModel != null) {
                for (ResolvedDependency project : DependenciesFilter.getReloadableModules((ApplicationModel)appModel)) {
                    DevModeContext.ModuleInfo module = this.toModule(project);
                    if (project.getKey().equals((Object)appModel.getAppArtifact().getKey()) && project.getVersion().equals(appModel.getAppArtifact().getVersion())) {
                        devModeContext.setApplicationRoot(module);
                        continue;
                    }
                    devModeContext.getAdditionalModules().add(module);
                    devModeContext.getLocalArtifacts().add(project.getKey());
                }
            }
        }
        catch (AppModelResolverException e) {
            log.error((Object)"Failed to load workspace, hot reload will not be available", (Throwable)e);
        }
        this.terminateIfRunning();
        this.delegate = new IsolatedDevModeMain();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DevModeContext.class.getName(), devModeContext);
        params.put(DevModeType.class.getName(), DevModeType.LOCAL);
        this.delegate.accept(curatedApplication, (Map<String, Object>)params);
    }

    @Override
    public void close() {
        this.terminateIfRunning();
    }

    private void terminateIfRunning() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private DevModeContext.ModuleInfo toModule(ResolvedDependency module) throws BootstrapGradleException {
        String classesDir = null;
        String generatedSourcesDir = null;
        LinkedHashSet<Path> sourceParents = new LinkedHashSet<Path>();
        PathList.Builder srcPaths = PathList.builder();
        ArtifactSources sources = module.getSources();
        for (SourceDir src : sources.getSourceDirs()) {
            for (Path p : src.getSourceTree().getRoots()) {
                sourceParents.add(p.getParent());
                if (srcPaths.contains(p)) continue;
                srcPaths.add(p);
            }
            if (classesDir == null) {
                classesDir = src.getOutputDir().toString();
            }
            if (generatedSourcesDir != null || src.getAptSourcesDir() == null) continue;
            generatedSourcesDir = src.getAptSourcesDir().toString();
        }
        String resourceDirectory = null;
        PathList.Builder resourcesPaths = PathList.builder();
        for (SourceDir src : sources.getResourceDirs()) {
            for (Path p : src.getSourceTree().getRoots()) {
                if (resourcesPaths.contains(p)) continue;
                resourcesPaths.add(p);
            }
            if (resourceDirectory != null) continue;
            resourceDirectory = src.getOutputDir().toString();
        }
        return new DevModeContext.ModuleInfo.Builder().setArtifactKey(module.getKey()).setProjectDirectory(module.getWorkspaceModule().getModuleDir().getPath()).setSourcePaths((PathCollection)srcPaths.build()).setClassesPath(classesDir).setGeneratedSourcesPath(generatedSourcesDir).setResourcePaths((PathCollection)resourcesPaths.build()).setResourcesOutputPath(resourceDirectory).setSourceParents((PathCollection)PathList.from(sourceParents)).setPreBuildOutputDir(module.getWorkspaceModule().getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(module.getWorkspaceModule().getBuildDir().toString()).build();
    }
}

