/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Json;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassConditionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NativeImageReflectConfigStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void generateReflectConfig(BuildProducer<GeneratedResourceBuildItem> reflectConfig, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ForceNonWeakReflectiveClassBuildItem> nonWeakReflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<ReflectiveClassConditionBuildItem> reflectiveClassConditionBuildItems) {
        LinkedHashMap<String, ReflectionInfo> reflectiveClasses = new LinkedHashMap<String, ReflectionInfo>();
        HashSet<String> forcedNonWeakClasses = new HashSet<String>();
        for (ForceNonWeakReflectiveClassBuildItem forceNonWeakReflectiveClassBuildItem : nonWeakReflectiveClassBuildItems) {
            forcedNonWeakClasses.add(forceNonWeakReflectiveClassBuildItem.getClassName());
        }
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.isWeak(), reflectiveClassBuildItem.isSerialization(), reflectiveClassBuildItem.isUnsafeAllocated(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(reflectiveClasses, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(reflectiveClasses, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, true, false, false, false, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        for (ReflectiveClassConditionBuildItem reflectiveClassConditionBuildItem : reflectiveClassConditionBuildItems) {
            reflectiveClasses.computeIfPresent(reflectiveClassConditionBuildItem.getClassName(), (key, value) -> {
                value.typeReachable = reflectiveClassConditionBuildItem.getTypeReachable();
                return value;
            });
        }
        Json.JsonArrayBuilder root = Json.array();
        for (Map.Entry entry : reflectiveClasses.entrySet()) {
            int i;
            Json.JsonArrayBuilder paramsArray;
            Json.JsonObjectBuilder methodObject;
            Json.JsonArrayBuilder methodsArray;
            Json.JsonObjectBuilder json = Json.object();
            json.put("name", (String)entry.getKey());
            ReflectionInfo info = (ReflectionInfo)entry.getValue();
            if (info.typeReachable != null) {
                json.put("condition", Json.object().put("typeReachable", info.typeReachable));
            }
            if (info.constructors) {
                json.put("allDeclaredConstructors", true);
            } else if (!info.ctorSet.isEmpty()) {
                methodsArray = Json.array();
                for (ReflectiveMethodBuildItem ctor : info.ctorSet) {
                    methodObject = Json.object();
                    methodObject.put("name", ctor.getName());
                    paramsArray = Json.array();
                    for (i = 0; i < ctor.getParams().length; ++i) {
                        paramsArray.add(ctor.getParams()[i]);
                    }
                    methodObject.put("parameterTypes", paramsArray);
                    methodsArray.add(methodObject);
                }
                json.put("methods", methodsArray);
            }
            if (info.methods) {
                json.put("allDeclaredMethods", true);
            } else if (!info.methodSet.isEmpty()) {
                methodsArray = Json.array();
                for (ReflectiveMethodBuildItem method : info.methodSet) {
                    methodObject = Json.object();
                    methodObject.put("name", method.getName());
                    paramsArray = Json.array();
                    for (i = 0; i < method.getParams().length; ++i) {
                        paramsArray.add(method.getParams()[i]);
                    }
                    methodObject.put("parameterTypes", paramsArray);
                    methodsArray.add(methodObject);
                }
                json.put("methods", methodsArray);
            }
            if (info.fields) {
                json.put("allDeclaredFields", true);
            } else if (!info.fieldSet.isEmpty()) {
                Json.JsonArrayBuilder fieldsArray = Json.array();
                for (String fieldName : info.fieldSet) {
                    fieldsArray.add(Json.object().put("name", fieldName));
                }
                json.put("fields", fieldsArray);
            }
            if (info.unsafeAllocated) {
                json.put("unsafeAllocated", true);
            }
            root.add(json);
        }
        try (StringWriter stringWriter = new StringWriter();){
            root.appendTo((Appendable)stringWriter);
            reflectConfig.produce(new GeneratedResourceBuildItem("META-INF/native-image/reflect-config.json", stringWriter.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo();
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, Set<String> forcedNonWeakClasses, boolean constructors, boolean method, boolean fields, boolean weak, boolean serialization, boolean unsafeAllocated, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                String typeReachable = !forcedNonWeakClasses.contains(cl) && weak ? cl : null;
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields, typeReachable, serialization, unsafeAllocated));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (fields) {
                existing.fields = true;
            }
            if (serialization) {
                existing.serialization = true;
            }
            if (!unsafeAllocated) continue;
            existing.unsafeAllocated = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo();
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        boolean serialization;
        boolean unsafeAllocated;
        String typeReachable;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo() {
            this(false, false, false, null, false, false);
        }

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields, String typeReachable, boolean serialization, boolean unsafeAllocated) {
            this.methods = methods;
            this.fields = fields;
            this.typeReachable = typeReachable;
            this.constructors = constructors;
            this.serialization = serialization;
            this.unsafeAllocated = unsafeAllocated;
        }
    }
}

