/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.deployment.dev.testing.HtmlAnsiOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class LogCapturingOutputFilter
implements BiPredicate<String, Boolean> {
    private static final Logger log = Logger.getLogger(LogCapturingOutputFilter.class);
    private final CuratedApplication application;
    private final List<String> logOutput = new ArrayList<String>();
    private final List<String> errorOutput = new ArrayList<String>();
    private final boolean mergeErrorStream;
    private final boolean convertToHtml;
    private final Supplier<Boolean> finalPredicate;

    public LogCapturingOutputFilter(CuratedApplication application, boolean mergeErrorStream, boolean convertToHtml, Supplier<Boolean> finalPredicate) {
        this.application = application;
        this.mergeErrorStream = mergeErrorStream;
        this.convertToHtml = convertToHtml;
        this.finalPredicate = finalPredicate;
    }

    public List<String> captureOutput() {
        ArrayList<String> ret = new ArrayList<String>(this.logOutput);
        this.logOutput.clear();
        return ret;
    }

    public List<String> captureErrorOutput() {
        ArrayList<String> ret = new ArrayList<String>(this.errorOutput);
        this.errorOutput.clear();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(String logRecord, Boolean errorStream) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        if (cl == null) {
            return true;
        }
        while (cl.getParent() != null) {
            if (cl == this.application.getAugmentClassLoader() || cl == this.application.getBaseRuntimeClassLoader()) {
                List<String> list = this.logOutput;
                synchronized (list) {
                    block13: {
                        if (this.convertToHtml) {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            HtmlAnsiOutputStream outputStream = new HtmlAnsiOutputStream(out){};
                            try {
                                outputStream.write(logRecord.getBytes(StandardCharsets.UTF_8));
                                if (this.mergeErrorStream || !errorStream.booleanValue()) {
                                    this.logOutput.add(out.toString(StandardCharsets.UTF_8));
                                    break block13;
                                }
                                this.errorOutput.add(out.toString(StandardCharsets.UTF_8));
                            }
                            catch (IOException e) {
                                log.error((Object)"Failed to capture log record", (Throwable)e);
                                this.logOutput.add(logRecord);
                            }
                        } else if (this.mergeErrorStream || !errorStream.booleanValue()) {
                            this.logOutput.add(logRecord);
                        } else {
                            this.errorOutput.add(logRecord);
                        }
                    }
                }
                return this.finalPredicate.get();
            }
            cl = cl.getParent();
        }
        return true;
    }
}

