/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

class DevServicesConfigBuildStep {
    DevServicesConfigBuildStep() {
    }

    @BuildStep
    List<DevServicesConfigResultBuildItem> deprecated(List<DevServicesNativeConfigResultBuildItem> items) {
        return items.stream().map(s -> new DevServicesConfigResultBuildItem(s.getKey(), s.getValue())).collect(Collectors.toList());
    }

    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    DevServicesLauncherConfigResultBuildItem setup(BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfig, List<DevServicesConfigResultBuildItem> devServicesConfigResultBuildItems, LiveReloadBuildItem liveReloadBuildItem) {
        HashMap<String, String> newProperties = new HashMap<String, String>(devServicesConfigResultBuildItems.stream().collect(Collectors.toMap(DevServicesConfigResultBuildItem::getKey, DevServicesConfigResultBuildItem::getValue)));
        Config config = ConfigProvider.getConfig();
        PreviousConfig oldProperties = liveReloadBuildItem.getContextObject(PreviousConfig.class);
        if (oldProperties != null) {
            for (Map.Entry<Object, Object> entry : oldProperties.config.entrySet()) {
                if (newProperties.containsKey(entry.getKey()) || !config.getOptionalValue((String)entry.getKey(), String.class).isEmpty()) continue;
                newProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            runtimeConfig.produce(new RunTimeConfigurationDefaultBuildItem((String)entry.getKey(), (String)entry.getValue()));
        }
        liveReloadBuildItem.setContextObject(PreviousConfig.class, new PreviousConfig(newProperties));
        return new DevServicesLauncherConfigResultBuildItem(Collections.unmodifiableMap(newProperties));
    }

    static class PreviousConfig {
        final Map<String, String> config;

        public PreviousConfig(Map<String, String> config) {
            this.config = config;
        }
    }
}

