/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jboss.logging.Logger;

public class FSWatchUtil {
    private static final Logger log = Logger.getLogger(FSWatchUtil.class);
    private final List<ExecutorService> executors = new ArrayList<ExecutorService>();
    private volatile boolean closed = false;

    public void observe(Collection<Watcher> watchers, long intervalMs) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> this.doObserve(watchers, intervalMs));
        this.executors.add(executorService);
    }

    private void doObserve(Collection<Watcher> watchers, long intervalMs) {
        HashMap<Path, Long> lastModified = new HashMap<Path, Long>();
        long lastCheck = 0L;
        boolean firstRun = true;
        while (!this.closed) {
            for (Watcher watcher : watchers) {
                try {
                    Path rootPath = watcher.rootPath;
                    List matchingPaths = Files.walk(rootPath, new FileVisitOption[0]).filter(path -> FilenameUtils.getExtension((String)path.toString()).equals(watcher.fileExtension)).collect(Collectors.toList());
                    ArrayList<Path> changedFiles = new ArrayList<Path>();
                    for (Path path2 : matchingPaths) {
                        long lastModifiedTime = Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis();
                        if (lastModifiedTime <= lastModified.computeIfAbsent(path2, whatever -> 0L)) continue;
                        changedFiles.add(path2);
                        lastModified.put(path2, lastModifiedTime);
                    }
                    if (firstRun || changedFiles.isEmpty()) continue;
                    watcher.action.accept(changedFiles);
                }
                catch (IOException e) {
                    log.debug((Object)"Failed checking for code gen source modifications", (Throwable)e);
                }
            }
            long toSleep = intervalMs - (System.currentTimeMillis() - lastCheck);
            if (toSleep > 0L) {
                try {
                    Thread.sleep(toSleep);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Watching for code gen interrupted");
                }
            }
            lastCheck = System.currentTimeMillis();
            firstRun = false;
        }
    }

    public void shutdown() {
        this.executors.forEach(ExecutorService::shutdown);
        this.executors.clear();
        this.closed = true;
    }

    public static class Watcher {
        private final Path rootPath;
        private final String fileExtension;
        private final Consumer<Collection<Path>> action;

        public Watcher(Path rootPath, String fileExtension, Consumer<Collection<Path>> action) {
            this.rootPath = rootPath;
            this.fileExtension = fileExtension;
            this.action = action;
        }
    }
}

