/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.matching;

import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.deployment.configuration.matching.FieldContainer;
import io.quarkus.deployment.configuration.matching.MapContainer;
import io.quarkus.runtime.configuration.NameIterator;
import java.util.List;

public final class PatternMapBuilder {
    private PatternMapBuilder() {
    }

    public static ConfigPatternMap<Container> makePatterns(List<RootDefinition> rootDefinitions) {
        ConfigPatternMap<Container> patternMap = new ConfigPatternMap<Container>();
        for (RootDefinition rootDefinition : rootDefinitions) {
            String rootName = rootDefinition.getRootName();
            ConfigPatternMap<Container> addTo = patternMap;
            if (!rootName.isEmpty()) {
                NameIterator ni = new NameIterator(rootName);
                assert (ni.hasNext());
                do {
                    String seg = ni.getNextSegment();
                    ConfigPatternMap<Container> child = addTo.getChild(seg);
                    ni.next();
                    if (child == null) {
                        child = new ConfigPatternMap();
                        addTo.addChild(seg, child);
                    }
                    addTo = child;
                } while (ni.hasNext());
            }
            PatternMapBuilder.addGroup(addTo, rootDefinition, null);
        }
        return patternMap;
    }

    private static void addGroup(ConfigPatternMap<Container> patternMap, ClassDefinition current, Container parent) {
        for (ClassDefinition.ClassMember member : current.getMembers()) {
            String propertyName = member.getPropertyName();
            ConfigPatternMap<Container> addTo = patternMap;
            if (!propertyName.isEmpty()) {
                NameIterator ni = new NameIterator(propertyName);
                assert (ni.hasNext());
                do {
                    String seg;
                    ConfigPatternMap<Container> child;
                    if ((child = addTo.getChild(seg = ni.getNextSegment())) == null) {
                        child = new ConfigPatternMap();
                        addTo.addChild(seg, child);
                    }
                    addTo = child;
                    ni.next();
                } while (ni.hasNext());
            }
            FieldContainer newNode = new FieldContainer(parent, member);
            PatternMapBuilder.addMember(addTo, member, newNode);
        }
    }

    private static void addMember(ConfigPatternMap<Container> patternMap, ClassDefinition.ClassMember member, Container container) {
        if (member instanceof ClassDefinition.ItemMember) {
            Container matched = patternMap.getMatched();
            if (matched != null) {
                throw new IllegalArgumentException("Multiple matching properties for name \"" + matched.getPropertyName() + "\" property was matched by both " + container.findField() + " and " + matched.findField() + ". This is likely because you have an incompatible combination of extensions that both define the same properties (e.g. including both reactive and blocking database extensions)");
            }
            patternMap.setMatched(container);
        } else if (member instanceof ClassDefinition.MapMember) {
            ClassDefinition.MapMember mapMember = (ClassDefinition.MapMember)member;
            ConfigPatternMap<Container> addTo = patternMap.getChild("{*}");
            if (addTo == null) {
                addTo = new ConfigPatternMap();
                patternMap.addChild("{*}", addTo);
            }
            ClassDefinition.ClassMember nestedMember = mapMember.getNested();
            PatternMapBuilder.addMember(addTo, nestedMember, new MapContainer(container, nestedMember));
        } else {
            assert (member instanceof ClassDefinition.GroupMember);
            PatternMapBuilder.addGroup(patternMap, ((ClassDefinition.GroupMember)member).getGroupDefinition(), container);
        }
    }
}

