/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.JniBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

public class JniProcessor {
    private static final Logger LOGGER = Logger.getLogger(JniProcessor.class);
    JniConfig jni;

    @BuildStep
    void setupJni(BuildProducer<JniBuildItem> jniProducer) {
        if (!this.jni.enable) {
            LOGGER.warn((Object)"Your application is setting the deprecated 'quarkus.jni.enable' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
        }
        if (this.jni.libraryPaths.isPresent()) {
            jniProducer.produce(new JniBuildItem(this.jni.libraryPaths.get()));
        }
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static class JniConfig {
        @ConfigItem
        Optional<List<String>> libraryPaths;
        @Deprecated
        @ConfigItem(defaultValue="true")
        boolean enable = true;

        JniConfig() {
        }
    }
}

