/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.runner.TransformerTarget;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class RuntimeClassLoader
extends ClassLoader
implements ClassOutput,
TransformerTarget {
    private static final Logger log = Logger.getLogger(RuntimeClassLoader.class);
    private final Map<String, byte[]> appClasses = new ConcurrentHashMap<String, byte[]>();
    private final Set<String> frameworkClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, byte[]> resources = new ConcurrentHashMap<String, byte[]>();
    private volatile Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = null;
    private volatile ClassLoader transformerSafeClassLoader;
    private final List<Path> applicationClassDirectories;
    private final Map<String, Path> applicationClasses;
    private final ProtectionDomain defaultProtectionDomain;
    private final Path frameworkClassesPath;
    private final Path transformerCache;
    private static final String DEBUG_CLASSES_DIR = System.getProperty("quarkus.debug.generated-classes-dir");
    private final ConcurrentHashMap<String, LoadingClass> loadingClasses = new ConcurrentHashMap();

    public RuntimeClassLoader(ClassLoader parent, List<Path> applicationClassesDirectories, Path frameworkClassesDirectory, Path transformerCache) {
        super(parent);
        try {
            final HashMap<String, Path> applicationClasses = new HashMap<String, Path>();
            for (final Path i : applicationClassesDirectories) {
                if (!Files.isDirectory(i, new LinkOption[0])) continue;
                Stream<Path> fileTreeElements = Files.walk(i, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    fileTreeElements.forEach(new Consumer<Path>(){

                        @Override
                        public void accept(Path path) {
                            if (path.toString().endsWith(".class")) {
                                applicationClasses.put(i.relativize(path).toString().replace('\\', '/'), path);
                            }
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileTreeElements == null) continue;
                    if (throwable != null) {
                        try {
                            fileTreeElements.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileTreeElements.close();
                }
            }
            this.defaultProtectionDomain = this.createDefaultProtectionDomain(applicationClassesDirectories.get(0));
            this.applicationClasses = applicationClasses;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.applicationClassDirectories = applicationClassesDirectories;
        this.frameworkClassesPath = frameworkClassesDirectory;
        if (!Files.isDirectory(frameworkClassesDirectory, new LinkOption[0])) {
            throw new IllegalStateException("Test classes directory path does not point to an existing directory: " + this.frameworkClassesPath);
        }
        this.transformerCache = transformerCache;
    }

    @Override
    public Enumeration<URL> getResources(String nm) throws IOException {
        URL appResource;
        String name = this.sanitizeName(nm);
        ArrayList<URL> resources = new ArrayList<URL>();
        URL resource = this.getQuarkusResource(name);
        if (resource != null) {
            resources.add(resource);
        }
        if ((appResource = this.findApplicationResource(name)) != null) {
            resources.add(appResource);
        }
        Enumeration<URL> e = super.getResources(name);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
        return Collections.enumeration(resources);
    }

    @Override
    public URL getResource(String nm) {
        String name = this.sanitizeName(nm);
        URL resource = this.getQuarkusResource(name);
        if (resource != null) {
            return resource;
        }
        URL appResource = this.findApplicationResource(name);
        if (appResource != null) {
            return appResource;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String nm) {
        String name = this.sanitizeName(nm);
        byte[] data = this.resources.get(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        data = this.findApplicationResourceContent(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        return super.getResourceAsStream(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> ex = this.findLoadedClass(name);
        if (ex != null) {
            return ex;
        }
        if (this.appClasses.containsKey(name) || !this.frameworkClasses.contains(name) && this.getClassInApplicationClassPaths(name) != null) {
            return this.findClass(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> existing = this.findLoadedClass(name);
        if (existing != null) {
            return existing;
        }
        byte[] bytes = this.appClasses.get(name);
        if (bytes != null) {
            try {
                this.definePackage(name);
                return this.defineClass(name, bytes, 0, bytes.length, this.defaultProtectionDomain);
            }
            catch (Error e) {
                existing = this.findLoadedClass(name);
                if (existing != null) {
                    return existing;
                }
                throw e;
            }
        }
        Path classLoc = this.getClassInApplicationClassPaths(name);
        if (classLoc != null) {
            LoadingClass res = new LoadingClass(new CompletableFuture(), Thread.currentThread());
            LoadingClass loadingClass = this.loadingClasses.putIfAbsent(name, res);
            if (loadingClass != null) {
                if (loadingClass.initiator == Thread.currentThread()) {
                    throw new LinkageError("Load caused recursion in RuntimeClassLoader, this is a Quarkus bug loading class: " + name);
                }
                try {
                    return loadingClass.value.get();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException("Failed to load " + name, e);
                }
            }
            try {
                try {
                    bytes = Files.readAllBytes(classLoc);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Failed to load class", e);
                }
                bytes = this.handleTransform(name, bytes);
                this.definePackage(name);
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, this.defaultProtectionDomain);
                res.value.complete(clazz);
                return clazz;
            }
            catch (RuntimeException e) {
                res.value.completeExceptionally(e);
                throw e;
            }
            catch (Throwable e) {
                res.value.completeExceptionally(e);
                throw e;
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public void writeClass(boolean applicationClass, String className, byte[] data) {
        if (applicationClass) {
            String dotName = className.replace('/', '.');
            this.appClasses.put(dotName, data);
            if (DEBUG_CLASSES_DIR != null) {
                try {
                    File debugPath = new File(DEBUG_CLASSES_DIR);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File classFile = new File(debugPath, dotName + ".class");
                    classFile.getParentFile().mkdirs();
                    try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                        classWriter.write(data);
                    }
                    log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            this.frameworkClasses.add(className.replace('/', '.'));
            Path fileName = this.frameworkClassesPath.resolve(className.replace('.', '/') + ".class");
            try {
                Files.createDirectories(fileName.getParent(), new FileAttribute[0]);
                try (FileOutputStream out = new FileOutputStream(fileName.toFile());){
                    out.write(data);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Writer writeSource(String className) {
        if (DEBUG_CLASSES_DIR != null) {
            try {
                File debugPath = new File(DEBUG_CLASSES_DIR);
                if (!debugPath.exists()) {
                    debugPath.mkdir();
                }
                File classFile = new File(debugPath, className + ".zig");
                classFile.getParentFile().mkdirs();
                log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
                return new OutputStreamWriter((OutputStream)new FileOutputStream(classFile), StandardCharsets.UTF_8);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ClassOutput.super.writeSource(className);
    }

    @Override
    public void setTransformers(Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> functions) {
        this.bytecodeTransformers = functions;
        this.transformerSafeClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void setApplicationArchives(List<Path> archives) {
        if (this.bytecodeTransformers == null) {
            return;
        }
        try {
            for (final Path root : archives) {
                final HashMap classes = new HashMap();
                final AtomicBoolean transform = new AtomicBoolean();
                try (Stream<Path> fileTreeElements = Files.walk(root, new FileVisitOption[0]);){
                    fileTreeElements.forEach(new Consumer<Path>(){

                        @Override
                        public void accept(Path path) {
                            if (path.toString().endsWith(".class")) {
                                String key = root.relativize(path).toString().replace('\\', '/');
                                classes.put(key, path);
                                if (RuntimeClassLoader.this.bytecodeTransformers.containsKey(key.substring(0, key.length() - ".class".length()).replace("/", "."))) {
                                    transform.set(true);
                                }
                            }
                        }
                    });
                }
                if (!transform.get()) continue;
                this.applicationClasses.putAll(classes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeResource(String name, byte[] data) throws IOException {
        this.resources.put(name, data);
    }

    public Class<?> visibleDefineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return super.defineClass(name, b, off, len, this.defaultProtectionDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String name) {
        String pkgName = this.getPackageNameFromClassName(name);
        if (pkgName != null && this.getPackage(pkgName) == null) {
            Object object = this.getClassLoadingLock(pkgName);
            synchronized (object) {
                if (this.getPackage(pkgName) == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFileContent(Path path) {
        File file = path.toFile();
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
        }
        int intLength = (int)fileLength;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(intLength);
            int reasonableBufferSize = Math.min(intLength, 2048);
            byte[] buf = new byte[reasonableBufferSize];
            while ((r = in.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file " + path, e);
        }
    }

    private byte[] handleTransform(String name, byte[] bytes) {
        ClassWriter writer;
        if (this.bytecodeTransformers == null || this.bytecodeTransformers.isEmpty()) {
            return bytes;
        }
        List<BiFunction<String, ClassVisitor, ClassVisitor>> transformers = this.bytecodeTransformers.get(name);
        if (transformers == null) {
            return bytes;
        }
        Path hashPath = null;
        if (this.transformerCache != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] thedigest = md.digest(bytes);
                String hash = Base64.getUrlEncoder().encodeToString(thedigest);
                hashPath = this.transformerCache.resolve(hash);
                if (Files.exists(hashPath, new LinkOption[0])) {
                    return RuntimeClassLoader.readFileContent(hashPath);
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to load transformed class from cache", (Throwable)e);
            }
        }
        ClassReader cr = new ClassReader(bytes);
        ClassWriter visitor = writer = new ClassWriter(cr, 3){

            protected ClassLoader getClassLoader() {
                return RuntimeClassLoader.this.transformerSafeClassLoader;
            }
        };
        for (BiFunction<String, ClassVisitor, ClassVisitor> i : transformers) {
            visitor = i.apply(name, (ClassVisitor)visitor);
        }
        cr.accept((ClassVisitor)visitor, 0);
        byte[] data = writer.toByteArray();
        if (hashPath != null) {
            try {
                File file = hashPath.toFile();
                file.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(file);){
                    out.write(data);
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to write class to cache", (Throwable)e);
            }
        }
        return data;
    }

    private String sanitizeName(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private Path getClassInApplicationClassPaths(String name) {
        String fileName = name.replace('.', '/') + ".class";
        return this.applicationClasses.get(fileName);
    }

    private URL findApplicationResource(String name) {
        Path i;
        Path resourcePath = null;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        Iterator<Path> iterator = this.applicationClassDirectories.iterator();
        while (iterator.hasNext() && !Files.exists(resourcePath = (i = iterator.next()).resolve(name), new LinkOption[0])) {
        }
        try {
            return resourcePath != null && Files.exists(resourcePath, new LinkOption[0]) ? resourcePath.toUri().toURL() : null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] findApplicationResourceContent(String name) {
        Path resourcePath = null;
        for (Path i : this.applicationClassDirectories) {
            resourcePath = i.resolve(name);
            if (!Files.exists(resourcePath, new LinkOption[0])) continue;
            return RuntimeClassLoader.readFileContent(resourcePath);
        }
        return null;
    }

    private URL getQuarkusResource(final String name) {
        byte[] data = this.resources.get(name);
        if (data != null) {
            String path = "quarkus:" + name;
            try {
                URL url = new URL(null, path, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream((byte[])RuntimeClassLoader.this.resources.get(name));
                            }
                        };
                    }
                });
                return url;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL: " + path);
            }
        }
        return null;
    }

    private ProtectionDomain createDefaultProtectionDomain(Path applicationClasspath) {
        URL url = null;
        if (applicationClasspath != null) {
            try {
                URI uri = applicationClasspath.toUri();
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                log.error((Object)("URL codeSource location for path " + applicationClasspath + " could not be created."), (Throwable)e);
            }
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        ProtectionDomain protectionDomain = new ProtectionDomain(codesource, null, this, null);
        return protectionDomain;
    }

    static {
        RuntimeClassLoader.registerAsParallelCapable();
    }

    static final class LoadingClass {
        final CompletableFuture<Class<?>> value;
        final Thread initiator;

        LoadingClass(CompletableFuture<Class<?>> value, Thread initiator) {
            this.value = value;
            this.initiator = initiator;
        }
    }
}

