/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class IoUtil {
    public static InputStream readClass(ClassLoader classLoader, String className) {
        return classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
    }

    public static byte[] readClassAsBytes(ClassLoader classLoader, String className) throws IOException {
        try (InputStream stream = IoUtil.readClass(classLoader, className);){
            byte[] byArray = IoUtil.readBytes(stream);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }
}

