/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.index.ConstPoolScanner;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassTransformingBuildStep {
    private static final Logger log = Logger.getLogger(ClassTransformingBuildStep.class);
    private static final Map<String, TransformedClassesBuildItem.TransformedClass> transformedClassesCache = new ConcurrentHashMap<String, TransformedClassesBuildItem.TransformedClass>();
    private static volatile BiFunction<String, byte[], byte[]> lastTransformers;

    public static byte[] transform(String className, byte[] classData) {
        if (lastTransformers == null) {
            return classData;
        }
        return lastTransformers.apply(className, classData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    TransformedClassesBuildItem handleClassTransformation(List<BytecodeTransformerBuildItem> bytecodeTransformerBuildItems, ApplicationArchivesBuildItem appArchives, LiveReloadBuildItem liveReloadBuildItem, final LaunchModeBuildItem launchModeBuildItem) throws ExecutionException, InterruptedException {
        if (bytecodeTransformerBuildItems.isEmpty()) {
            return new TransformedClassesBuildItem(Collections.emptyMap());
        }
        final HashMap<String, List> bytecodeTransformers = new HashMap<String, List>(bytecodeTransformerBuildItems.size());
        final HashSet<String> noConstScanning = new HashSet<String>();
        final HashMap<String, Set> constScanning = new HashMap<String, Set>();
        final HashSet<String> eager = new HashSet<String>();
        HashSet<String> nonCacheable = new HashSet<String>();
        for (BytecodeTransformerBuildItem i : bytecodeTransformerBuildItems) {
            bytecodeTransformers.computeIfAbsent(i.getClassToTransform(), h -> new ArrayList()).add(i);
            if (i.getRequireConstPoolEntry() == null || i.getRequireConstPoolEntry().isEmpty()) {
                noConstScanning.add(i.getClassToTransform());
            } else {
                constScanning.computeIfAbsent(i.getClassToTransform(), s -> new HashSet()).addAll(i.getRequireConstPoolEntry());
            }
            if (i.isEager()) {
                eager.add(i.getClassToTransform());
            }
            if (i.isCacheable()) continue;
            nonCacheable.add(i.getClassToTransform());
        }
        final QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        ConcurrentHashMap<String, Path> transformedToArchive = new ConcurrentHashMap<String, Path>();
        ExecutorService executorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ConcurrentLinkedDeque<Future<TransformedClassesBuildItem.TransformedClass>> transformed = new ConcurrentLinkedDeque<Future<TransformedClassesBuildItem.TransformedClass>>();
        HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar = new HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>>();
        final ClassLoader transformCl = Thread.currentThread().getContextClassLoader();
        lastTransformers = new BiFunction<String, byte[], byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] apply(String className, byte[] originalBytes) {
                List classTransformers = (List)bytecodeTransformers.get(className);
                if (classTransformers == null) {
                    return originalBytes;
                }
                List visitors = classTransformers.stream().map(BytecodeTransformerBuildItem::getVisitorFunction).filter(Objects::nonNull).collect(Collectors.toList());
                List preVisitFunctions = classTransformers.stream().map(BytecodeTransformerBuildItem::getInputTransformer).filter(Objects::nonNull).collect(Collectors.toList());
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(transformCl);
                    String classFileName = className.replace(".", "/") + ".class";
                    List archives = cl.getElementsWithResource(classFileName);
                    if (!archives.isEmpty()) {
                        ClassPathElement classPathElement = (ClassPathElement)archives.get(0);
                        Path jar = classPathElement.getRoot();
                        byte[] classData = classPathElement.getResource(classFileName).getData();
                        Set constValues = (Set)constScanning.get(className);
                        if (constValues != null && !noConstScanning.contains(className) && !ConstPoolScanner.constPoolEntryPresent(classData, constValues)) {
                            byte[] byArray = originalBytes;
                            return byArray;
                        }
                        byte[] data = ClassTransformingBuildStep.this.transformClass(className, visitors, classData, preVisitFunctions);
                        TransformedClassesBuildItem.TransformedClass transformedClass = new TransformedClassesBuildItem.TransformedClass(className, data, classFileName, eager.contains(className));
                        byte[] byArray = transformedClass.getData();
                        return byArray;
                    }
                    byte[] byArray = originalBytes;
                    return byArray;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        };
        try {
            for (Map.Entry entry : bytecodeTransformers.entrySet()) {
                boolean cacheable;
                final String className = (String)entry.getKey();
                boolean bl = cacheable = !nonCacheable.contains(className);
                if (cacheable && transformedClassesCache.containsKey(className) && liveReloadBuildItem.getChangeInformation() != null && !liveReloadBuildItem.getChangeInformation().getChangedClasses().contains(className)) {
                    this.handleTransformedClass(transformedToArchive, transformedClassesByJar, transformedClassesCache.get(className));
                    continue;
                }
                final String classFileName = className.replace(".", "/") + ".class";
                List archives = cl.getElementsWithResource(classFileName);
                if (!archives.isEmpty()) {
                    final ClassPathElement classPathElement = (ClassPathElement)archives.get(0);
                    Path jar = classPathElement.getRoot();
                    if (jar == null) {
                        log.warnf("Cannot transform %s as its containing application archive could not be found.", entry.getKey());
                        continue;
                    }
                    final List visitors = ((List)entry.getValue()).stream().map(BytecodeTransformerBuildItem::getVisitorFunction).filter(Objects::nonNull).collect(Collectors.toList());
                    final List preVisitFunctions = ((List)entry.getValue()).stream().map(BytecodeTransformerBuildItem::getInputTransformer).filter(Objects::nonNull).collect(Collectors.toList());
                    transformedToArchive.put(classFileName, jar);
                    transformed.add(executorPool.submit(new Callable<TransformedClassesBuildItem.TransformedClass>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public TransformedClassesBuildItem.TransformedClass call() throws Exception {
                            ClassLoader old = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(transformCl);
                                Set constValues = (Set)constScanning.get(className);
                                byte[] classData = classPathElement.getResource(classFileName).getData();
                                if (constValues != null && !noConstScanning.contains(className) && !ConstPoolScanner.constPoolEntryPresent(classData, constValues)) {
                                    TransformedClassesBuildItem.TransformedClass transformedClass = null;
                                    return transformedClass;
                                }
                                byte[] data = ClassTransformingBuildStep.this.transformClass(className, visitors, classData, preVisitFunctions);
                                TransformedClassesBuildItem.TransformedClass transformedClass = new TransformedClassesBuildItem.TransformedClass(className, data, classFileName, eager.contains(className));
                                if (cacheable && launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT) {
                                    transformedClassesCache.put(className, transformedClass);
                                }
                                TransformedClassesBuildItem.TransformedClass transformedClass2 = transformedClass;
                                return transformedClass2;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                            }
                        }
                    }));
                    continue;
                }
                log.warnf("Cannot transform %s as its containing application archive could not be found.", entry.getKey());
            }
        }
        finally {
            executorPool.shutdown();
        }
        if (!transformed.isEmpty()) {
            for (Future future : transformed) {
                TransformedClassesBuildItem.TransformedClass res = (TransformedClassesBuildItem.TransformedClass)future.get();
                if (res == null) continue;
                this.handleTransformedClass(transformedToArchive, transformedClassesByJar, res);
            }
        }
        return new TransformedClassesBuildItem(transformedClassesByJar);
    }

    private byte[] transformClass(String className, List<BiFunction<String, ClassVisitor, ClassVisitor>> visitors, byte[] classData, List<BiFunction<String, byte[], byte[]>> preVisitFunctions) {
        byte[] data;
        for (BiFunction<String, byte[], byte[]> i : preVisitFunctions) {
            classData = i.apply(className, classData);
        }
        if (!visitors.isEmpty()) {
            QuarkusClassWriter writer;
            ClassReader cr = new ClassReader(classData);
            QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
            for (BiFunction<String, ClassVisitor, ClassVisitor> i : visitors) {
                visitor = i.apply(className, (ClassVisitor)visitor);
            }
            cr.accept((ClassVisitor)visitor, 0);
            data = writer.toByteArray();
        } else {
            data = classData;
        }
        if (BootstrapDebug.DEBUG_TRANSFORMED_CLASSES_DIR != null) {
            File debugPath = new File(BootstrapDebug.DEBUG_TRANSFORMED_CLASSES_DIR);
            if (!debugPath.exists()) {
                debugPath.mkdir();
            }
            File classFile = new File(debugPath, className.replace(".", "/") + ".class");
            classFile.getParentFile().mkdirs();
            try {
                FileOutputStream classWriter = new FileOutputStream(classFile);
                Object object = null;
                try {
                    classWriter.write(data);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (classWriter != null) {
                        if (object != null) {
                            try {
                                classWriter.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            classWriter.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Failed to write transformed class %s", (Object)className);
            }
            log.infof("Wrote transformed class to %s", (Object)classFile.getAbsolutePath());
        }
        return data;
    }

    private void handleTransformedClass(Map<String, Path> transformedToArchive, Map<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar, TransformedClassesBuildItem.TransformedClass res) {
        transformedClassesByJar.computeIfAbsent(transformedToArchive.get(res.getFileName()), a -> new HashSet()).add(res);
    }
}

