/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;

public class NativeImageBuildLocalRunner
extends NativeImageBuildRunner {
    private final String nativeImageExecutable;

    public NativeImageBuildLocalRunner(String nativeImageExecutable) {
        this.nativeImageExecutable = nativeImageExecutable;
    }

    @Override
    public void cleanupServer(File outputDir) throws InterruptedException, IOException {
        String[] cleanupCommand = new String[]{this.nativeImageExecutable, "--server-shutdown"};
        this.runCommand(cleanupCommand, null, outputDir);
    }

    @Override
    protected String[] getGraalVMVersionCommand(List<String> args) {
        return this.buildCommand(args);
    }

    @Override
    protected String[] getBuildCommand(List<String> args) {
        return this.buildCommand(args);
    }

    private String[] buildCommand(List<String> args) {
        return (String[])Stream.concat(Stream.of(this.nativeImageExecutable), args.stream()).toArray(String[]::new);
    }
}

