/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.deployment.dev.ClassLoaderCompiler;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.deployment.dev.IsolatedRemoteDevModeMain;
import io.quarkus.deployment.util.FSWatchUtil;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext,
Closeable {
    private static final Logger log = Logger.getLogger(RuntimeUpdatesProcessor.class);
    private static final String CLASS_EXTENSION = ".class";
    static volatile RuntimeUpdatesProcessor INSTANCE;
    private final Path applicationRoot;
    private final DevModeContext context;
    private final ClassLoaderCompiler compiler;
    private final DevModeType devModeType;
    volatile Throwable compileProblem;
    private volatile Map<String, Boolean> watchedFilePaths = Collections.emptyMap();
    private volatile boolean firstScanDone = false;
    private final Map<Path, Long> sourceFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Long> watchedFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Long> classFileChangeTimeStamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Path> classFilePathToSourceFilePath = new ConcurrentHashMap<Path, Path>();
    private final Map<String, Set<Path>> correspondingResources = new ConcurrentHashMap<String, Set<Path>>();
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Set<String>>> noRestartChangesConsumers = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    private final List<HotReplacementSetup> hotReplacementSetup = new ArrayList<HotReplacementSetup>();
    private final Consumer<Set<String>> restartCallback;
    private final BiConsumer<DevModeContext.ModuleInfo, String> copyResourceNotification;

    public RuntimeUpdatesProcessor(Path applicationRoot, DevModeContext context, ClassLoaderCompiler compiler, DevModeType devModeType, Consumer<Set<String>> restartCallback, BiConsumer<DevModeContext.ModuleInfo, String> copyResourceNotification) {
        this.applicationRoot = applicationRoot;
        this.context = context;
        this.compiler = compiler;
        this.devModeType = devModeType;
        this.restartCallback = restartCallback;
        this.copyResourceNotification = copyResourceNotification;
    }

    public Path getClassesDir() {
        Iterator<DevModeContext.ModuleInfo> iterator = this.context.getAllModules().iterator();
        if (iterator.hasNext()) {
            DevModeContext.ModuleInfo i = iterator.next();
            return Paths.get(i.getResourcePath(), new String[0]);
        }
        return null;
    }

    public List<Path> getSourcesDir() {
        return this.context.getAllModules().stream().flatMap(m -> m.getSourcePaths().stream()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    public List<Path> getResourcesDir() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo i : this.context.getAllModules()) {
            if (i.getResourcePath() != null) {
                ret.add(Paths.get(i.getResourcePath(), new String[0]));
                continue;
            }
            if (i.getResourcesOutputPath() == null) continue;
            ret.add(Paths.get(i.getResourcesOutputPath(), new String[0]));
        }
        Collections.reverse(ret);
        return ret;
    }

    public Throwable getDeploymentProblem() {
        return this.compileProblem != null ? this.compileProblem : IsolatedDevModeMain.deploymentProblem;
    }

    public void setRemoteProblem(Throwable throwable) {
        this.compileProblem = throwable;
    }

    public void updateFile(String file, byte[] data) {
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        try {
            Path resolve = this.applicationRoot.resolve(file);
            if (!Files.exists(resolve.getParent(), new LinkOption[0])) {
                Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
            }
            Files.write(resolve, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isTest() {
        return this.context.isTest();
    }

    public DevModeType getDevModeType() {
        return this.devModeType;
    }

    public boolean doScan(boolean userInitiated) throws IOException {
        boolean restartNeeded;
        long startNanoseconds = System.nanoTime();
        for (Runnable step : this.preScanSteps) {
            try {
                step.run();
            }
            catch (Throwable t) {
                log.error((Object)"Pre Scan step failed", t);
            }
        }
        boolean classChanged = this.checkForChangedClasses();
        Set<String> filesChanged = this.checkForFileChange();
        boolean bl = restartNeeded = classChanged || IsolatedDevModeMain.deploymentProblem != null && userInitiated;
        if (!restartNeeded && !filesChanged.isEmpty()) {
            restartNeeded = filesChanged.stream().map(this.watchedFilePaths::get).anyMatch(Boolean.TRUE::equals);
        }
        if (restartNeeded) {
            this.restartCallback.accept(filesChanged);
            log.infof("Hot replace total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            return true;
        }
        if (!filesChanged.isEmpty()) {
            for (Consumer<Set<String>> consumer : this.noRestartChangesConsumers) {
                try {
                    consumer.accept(filesChanged);
                }
                catch (Throwable t) {
                    log.error((Object)"Changed files consumer failed", t);
                }
            }
            log.infof("Files changed but restart not needed - notified extensions in: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
        }
        return false;
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    public void consumeNoRestartChanges(Consumer<Set<String>> consumer) {
        this.noRestartChangesConsumers.add(consumer);
    }

    public Set<String> syncState(Map<String, String> fileHashes) {
        if (this.getDevModeType() != DevModeType.REMOTE_SERVER_SIDE) {
            throw new RuntimeException("Can only sync state on the server side of remote dev mode");
        }
        HashSet<String> ret = new HashSet<String>();
        try {
            HashMap<String, String> ourHashes = new HashMap<String, String>(IsolatedRemoteDevModeMain.createHashes(this.applicationRoot));
            for (Map.Entry<String, String> entry : fileHashes.entrySet()) {
                String ours = (String)ourHashes.remove(entry.getKey());
                if (Objects.equals(ours, entry.getValue())) continue;
                ret.add(entry.getKey());
            }
            for (Map.Entry<String, String> entry : ourHashes.entrySet()) {
                String file = entry.getKey();
                if (file.endsWith("META-INF/MANIFEST.MF") || file.contains("META-INF/maven") || !file.contains("/")) continue;
                log.info((Object)("Deleting removed file " + file));
                Files.deleteIfExists(this.applicationRoot.resolve(file));
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean checkForChangedClasses() throws IOException {
        boolean hasChanges = false;
        boolean ignoreFirstScanChanges = !this.firstScanDone;
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            ArrayList<Path> moduleChangedSourceFilePaths = new ArrayList<Path>();
            for (String sourcePath : module.getSourcePaths()) {
                Set changedSourceFiles;
                Path start = Paths.get(sourcePath, new String[0]);
                if (!Files.exists(start, new LinkOption[0])) continue;
                try (Stream<Path> sourcesStream = Files.walk(start, new FileVisitOption[0]);){
                    changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent() && this.sourceFileWasRecentModified((Path)p, ignoreFirstScanChanges)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
                }
                if (changedSourceFiles.isEmpty()) continue;
                log.info((Object)("Changed source files detected, recompiling " + changedSourceFiles));
                try {
                    Set changedPaths = changedSourceFiles.stream().map(File::toPath).collect(Collectors.toSet());
                    moduleChangedSourceFilePaths.addAll(changedPaths);
                    this.compiler.compile(sourcePath, changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
                    this.compileProblem = null;
                }
                catch (Exception e) {
                    this.compileProblem = e;
                    return false;
                }
            }
            if (!this.checkForClassFilesChangesInModule(module, moduleChangedSourceFilePaths, ignoreFirstScanChanges)) continue;
            hasChanges = true;
        }
        this.firstScanDone = true;
        return hasChanges;
    }

    public Throwable getCompileProblem() {
        return this.compileProblem;
    }

    private boolean checkForClassFilesChangesInModule(DevModeContext.ModuleInfo module, List<Path> moduleChangedSourceFiles, boolean isInitialRun) {
        boolean hasChanges;
        boolean bl = hasChanges = !moduleChangedSourceFiles.isEmpty();
        if (module.getClassesPath() == null) {
            return hasChanges;
        }
        try {
            for (String folder : module.getClassesPath().split(File.pathSeparator)) {
                Path moduleClassesPath = Paths.get(folder, new String[0]);
                if (!Files.exists(moduleClassesPath, new LinkOption[0])) continue;
                try (Stream<Path> classesStream = Files.walk(moduleClassesPath, new FileVisitOption[0]);){
                    Set classFilePaths = ((Stream)classesStream.parallel()).filter(path -> path.toString().endsWith(CLASS_EXTENSION)).collect(Collectors.toSet());
                    for (Path classFilePath : classFilePaths) {
                        Path sourceFilePath = this.retrieveSourceFilePathForClassFile(classFilePath, moduleChangedSourceFiles, module);
                        if (sourceFilePath != null) {
                            if (!sourceFilePath.toFile().exists()) {
                                this.cleanUpClassFile(classFilePath);
                                this.sourceFileTimestamps.remove(sourceFilePath);
                                hasChanges = true;
                                continue;
                            }
                            this.classFilePathToSourceFilePath.put(classFilePath, sourceFilePath);
                            if (this.classFileWasRecentModified(classFilePath, isInitialRun)) {
                                hasChanges = true;
                                continue;
                            }
                            if (!moduleChangedSourceFiles.contains(sourceFilePath)) continue;
                            this.cleanUpClassFile(classFilePath);
                            hasChanges = true;
                            continue;
                        }
                        if (!this.classFileWasRecentModified(classFilePath, isInitialRun)) continue;
                        hasChanges = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return hasChanges;
    }

    private Path retrieveSourceFilePathForClassFile(Path classFilePath, List<Path> moduleChangedSourceFiles, DevModeContext.ModuleInfo module) {
        Path sourceFilePath = this.classFilePathToSourceFilePath.get(classFilePath);
        if (sourceFilePath == null || moduleChangedSourceFiles.contains(sourceFilePath)) {
            sourceFilePath = this.compiler.findSourcePath(classFilePath, module.getSourcePaths(), module.getClassesPath());
        }
        return sourceFilePath;
    }

    private void cleanUpClassFile(Path classFilePath) throws IOException {
        Files.deleteIfExists(classFilePath);
        this.classFileChangeTimeStamps.remove(classFilePath);
        this.classFilePathToSourceFilePath.remove(classFilePath);
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    Set<String> checkForFileChange() {
        HashSet<String> ret = new HashSet<String>();
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            Path root;
            Set moduleResources = this.correspondingResources.computeIfAbsent(module.getName(), m -> Collections.newSetFromMap(new ConcurrentHashMap()));
            boolean doCopy = true;
            String rootPath = module.getResourcePath();
            String outputPath = module.getResourcesOutputPath();
            if (rootPath == null) {
                outputPath = rootPath = module.getClassesPath();
                doCopy = false;
            }
            if (rootPath == null || !Files.exists(root = Paths.get(rootPath, new String[0]), new LinkOption[0]) || !Files.isReadable(root)) continue;
            Path outputDir = Paths.get(outputPath, new String[0]);
            if (doCopy) {
                try {
                    HashSet seen = new HashSet(moduleResources);
                    try (Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);){
                        walk.forEach(path -> {
                            block16: {
                                try {
                                    Path relative = root.relativize((Path)path);
                                    Path target = outputDir.resolve(relative);
                                    seen.remove(target);
                                    if (this.watchedFileTimestamps.containsKey(path)) break block16;
                                    moduleResources.add(target);
                                    if (Files.exists(target, new LinkOption[0]) && Files.getLastModifiedTime(target, new LinkOption[0]).toMillis() >= Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()) break block16;
                                    if (Files.isDirectory(path, new LinkOption[0])) {
                                        Files.createDirectories(target, new FileAttribute[0]);
                                        break block16;
                                    }
                                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                    ret.add(relative.toString());
                                    byte[] data = Files.readAllBytes(path);
                                    try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                        out.write(data);
                                    }
                                    if (this.copyResourceNotification != null) {
                                        this.copyResourceNotification.accept(module, relative.toString());
                                    }
                                }
                                catch (Exception e) {
                                    log.error((Object)"Failed to copy resources", (Throwable)e);
                                }
                            }
                        });
                    }
                    for (Path i : seen) {
                        moduleResources.remove(i);
                        if (Files.isDirectory(i, new LinkOption[0])) continue;
                        Files.delete(i);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Failed to copy resources", (Throwable)e);
                }
            }
            for (String path2 : this.watchedFilePaths.keySet()) {
                Path file = root.resolve(path2);
                if (file.toFile().exists()) {
                    try {
                        Long existing;
                        long value = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                        if (value <= (existing = this.watchedFileTimestamps.get(file))) continue;
                        ret.add(path2);
                        log.infof("File change detected: %s", (Object)file);
                        if (doCopy && !Files.isDirectory(file, new LinkOption[0])) {
                            Path target = outputDir.resolve(path2);
                            byte[] data = Files.readAllBytes(file);
                            try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                out.write(data);
                            }
                        }
                        this.watchedFileTimestamps.put(file, value);
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.watchedFileTimestamps.put(file, 0L);
                Path target = outputDir.resolve(path2);
                try {
                    FileUtil.deleteDirectory(target);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return ret;
    }

    private boolean sourceFileWasRecentModified(Path sourcePath, boolean ignoreFirstScanChanges) {
        return this.checkIfFileModified(sourcePath, this.sourceFileTimestamps, ignoreFirstScanChanges);
    }

    private boolean classFileWasRecentModified(Path classFilePath, boolean ignoreFirstScanChanges) {
        return this.checkIfFileModified(classFilePath, this.classFileChangeTimeStamps, ignoreFirstScanChanges);
    }

    private boolean checkIfFileModified(Path path, Map<Path, Long> pathModificationTimes, boolean ignoreFirstScanChanges) {
        try {
            long lastModificationTime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            Long lastRecordedChange = pathModificationTimes.get(path);
            if (lastRecordedChange == null) {
                pathModificationTimes.put(path, lastModificationTime);
                return !ignoreFirstScanChanges;
            }
            if (lastRecordedChange != lastModificationTime) {
                pathModificationTimes.put(path, lastModificationTime);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public RuntimeUpdatesProcessor setWatchedFilePaths(Map<String, Boolean> watchedFilePaths) {
        this.watchedFilePaths = watchedFilePaths;
        this.watchedFileTimestamps.clear();
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
            }
            if (rootPath == null) continue;
            Path root = Paths.get(rootPath, new String[0]);
            for (String path : watchedFilePaths.keySet()) {
                Path config = root.resolve(path);
                if (config.toFile().exists()) {
                    try {
                        FileTime lastModifiedTime = Files.getLastModifiedTime(config, new LinkOption[0]);
                        this.watchedFileTimestamps.put(config, lastModifiedTime.toMillis());
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.watchedFileTimestamps.put(config, 0L);
            }
        }
        return this;
    }

    public void addHotReplacementSetup(HotReplacementSetup service) {
        this.hotReplacementSetup.add(service);
    }

    public void startupFailed() {
        for (HotReplacementSetup i : this.hotReplacementSetup) {
            i.handleFailedInitialStart();
        }
    }

    @Override
    public void close() throws IOException {
        this.compiler.close();
        FSWatchUtil.shutdown();
    }
}

