/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.quarkus.container.image.openshift.deployment.BuildStrategy;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
@ConfigMapping(prefix="quarkus.openshift")
public interface ContainerImageOpenshiftConfig {
    public static final String DEFAULT_NATIVE_TARGET_FILENAME = "application";
    public static final String DEFAULT_JVM_DOCKERFILE = "src/main/docker/Dockerfile.jvm";
    public static final String DEFAULT_NATIVE_DOCKERFILE = "src/main/docker/Dockerfile.native";
    public static final String DEFAULT_BUILD_LOG_LEVEL = "INFO";
    public static final String FALLBACK_JAR_DIRECTORY = "/deployments/";
    public static final String FALLBACK_NATIVE_BINARY_DIRECTORY = "/home/quarkus/";

    public static String getDefaultJvmImage(CompiledJavaVersionBuildItem.JavaVersion version) {
        if (version.isJava21OrHigher() == CompiledJavaVersionBuildItem.JavaVersion.Status.TRUE) {
            return "registry.access.redhat.com/ubi9/openjdk-21:1.21";
        }
        return "registry.access.redhat.com/ubi9/openjdk-17:1.21";
    }

    @WithDefault(value="binary")
    public BuildStrategy buildStrategy();

    public Optional<String> baseJvmImage();

    @WithDefault(value="quay.io/quarkus/ubi9-quarkus-native-binary-s2i:2.0")
    public String baseNativeImage();

    @WithDefault(value="src/main/docker/Dockerfile.jvm")
    public String jvmDockerfile();

    @WithDefault(value="src/main/docker/Dockerfile.native")
    public String nativeDockerfile();

    public Optional<List<String>> jvmArguments();

    public Optional<List<String>> nativeArguments();

    public Optional<String> jarDirectory();

    public Optional<String> jarFileName();

    public Optional<String> nativeBinaryDirectory();

    public Optional<String> nativeBinaryFileName();

    @WithDefault(value="PT5M")
    public Duration buildTimeout();

    @WithDefault(value="INFO")
    public Logger.Level buildLogLevel();

    public Optional<String> imagePushSecret();

    default public boolean hasDefaultBaseJvmImage() {
        return this.baseJvmImage().isPresent();
    }

    default public boolean hasDefaultBaseNativeImage() {
        return this.baseNativeImage().equals("quay.io/quarkus/ubi9-quarkus-native-binary-s2i:2.0");
    }

    default public boolean hasDefaultJvmDockerfile() {
        return this.jvmDockerfile().equals(DEFAULT_JVM_DOCKERFILE);
    }

    default public boolean hasDefaultNativeDockerfile() {
        return this.nativeDockerfile().equals(DEFAULT_NATIVE_DOCKERFILE);
    }

    default public List<String> getEffectiveJvmArguments() {
        ArrayList<String> effectiveJvmArguments = new ArrayList<String>();
        this.jvmArguments().ifPresent(effectiveJvmArguments::addAll);
        return effectiveJvmArguments;
    }
}

