/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.quarkus.kubernetes.spi.DeployStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.ConfigProvider;

public class OpenshiftUtils {
    private static final String OPENSHIFT_NAMESPACE = "quarkus.openshift.namespace";
    private static final String KUBERNETES_NAMESPACE = "quarkus.kubernetes.namespace";
    private static final String OPENSHIFT_DEPLOY_STRATEGY = "quarkus.openshift.deploy-strategy";
    private static final String KUBERNETES_DEPLOY_STRATEGY = "quarkus.kubernetes.deploy-strategy";

    public static boolean waitForImageStreamTags(OpenShiftClient client, Collection<HasMetadata> items, long amount, TimeUnit timeUnit) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        final ArrayList tags = new ArrayList();
        ((KubernetesListBuilder)((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).accept(new Visitor[]{new Decorator<SourceBuildStrategyFluent>(){

            public void visit(SourceBuildStrategyFluent strategy) {
                ObjectReference from = strategy.buildFrom();
                if (from.getKind().equals("ImageStreamTag")) {
                    tags.add(from.getName());
                }
            }
        }})).build();
        boolean tagsMissing = true;
        long started = System.currentTimeMillis();
        long elapsed = 0L;
        while (tagsMissing && elapsed < timeUnit.toMillis(amount) && !Thread.interrupted()) {
            tagsMissing = false;
            for (String tag : tags) {
                ImageStreamTag t = (ImageStreamTag)((Resource)client.imageStreamTags().withName(tag)).get();
                if (t != null) continue;
                tagsMissing = true;
            }
            if (!tagsMissing) continue;
            try {
                Thread.sleep(1000L);
                elapsed = System.currentTimeMillis() - started;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return !tagsMissing;
    }

    public static Optional<String> getNamespace() {
        return ConfigProvider.getConfig().getOptionalValue(OPENSHIFT_NAMESPACE, String.class).or(() -> ConfigProvider.getConfig().getOptionalValue(KUBERNETES_NAMESPACE, String.class));
    }

    public static DeployStrategy getDeployStrategy() {
        return ConfigProvider.getConfig().getOptionalValue(OPENSHIFT_DEPLOY_STRATEGY, DeployStrategy.class).or(() -> ConfigProvider.getConfig().getOptionalValue(KUBERNETES_DEPLOY_STRATEGY, DeployStrategy.class)).orElse(DeployStrategy.CreateOrUpdate);
    }
}

