/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.quarkus.container.image.openshift.deployment.BuildStrategy;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class S2iConfig {
    public static final String DEFAULT_BASE_JVM_JDK17_IMAGE = "registry.access.redhat.com/ubi8/openjdk-17:1.20";
    public static final String DEFAULT_BASE_JVM_JDK21_IMAGE = "registry.access.redhat.com/ubi8/openjdk-21:1.20";
    public static final String DEFAULT_BASE_NATIVE_IMAGE = "quay.io/quarkus/ubi-quarkus-native-binary-s2i:2.0";
    public static final String DEFAULT_NATIVE_TARGET_FILENAME = "application";
    public static final String DEFAULT_JVM_DOCKERFILE = "src/main/docker/Dockerfile.jvm";
    public static final String DEFAULT_NATIVE_DOCKERFILE = "src/main/docker/Dockerfile.native";
    public static final String FALLBACK_JAR_DIRECTORY = "/deployments/";
    public static final String FALLBACK_NATIVE_BINARY_DIRECTORY = "/home/quarkus/";
    @ConfigItem(defaultValue="binary")
    public BuildStrategy buildStrategy;
    @ConfigItem
    public Optional<String> baseJvmImage;
    @ConfigItem(defaultValue="quay.io/quarkus/ubi-quarkus-native-binary-s2i:2.0")
    public String baseNativeImage;
    @ConfigItem
    public Optional<List<String>> jvmArguments;
    @ConfigItem
    public Optional<List<String>> nativeArguments;
    @ConfigItem(defaultValue="/deployments/target/")
    public String jarDirectory;
    @ConfigItem
    public Optional<String> jarFileName;
    @ConfigItem(defaultValue="/home/quarkus/")
    public String nativeBinaryDirectory;
    @ConfigItem
    public Optional<String> nativeBinaryFileName;
    @ConfigItem(defaultValue="PT5M")
    Duration buildTimeout;

    public static String getDefaultJvmImage(CompiledJavaVersionBuildItem.JavaVersion version) {
        switch (version.isJava21OrHigher()) {
            case TRUE: {
                return DEFAULT_BASE_JVM_JDK21_IMAGE;
            }
        }
        return DEFAULT_BASE_JVM_JDK17_IMAGE;
    }

    public boolean hasDefaultBaseJvmImage() {
        return this.baseJvmImage.isPresent();
    }

    public boolean hasDefaultBaseNativeImage() {
        return this.baseNativeImage.equals(DEFAULT_BASE_NATIVE_IMAGE);
    }
}

