/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment.util;

import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import java.util.Optional;

public class EnablementUtil {
    public static boolean buildContainerImageNeeded(ContainerImageConfig containerImageConfig, Optional<ContainerImageBuildRequestBuildItem> buildRequest) {
        return containerImageConfig.isBuildExplicitlyEnabled() || buildRequest.isPresent() && !containerImageConfig.isBuildExplicitlyDisabled();
    }

    public static boolean pushContainerImageNeeded(ContainerImageConfig containerImageConfig, Optional<ContainerImagePushRequestBuildItem> pushRequest) {
        return containerImageConfig.isPushExplicitlyEnabled() || pushRequest.isPresent() && !containerImageConfig.isBuildExplicitlyDisabled() && !containerImageConfig.isPushExplicitlyDisabled();
    }

    public static boolean buildOrPushContainerImageNeeded(ContainerImageConfig containerImageConfig, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest) {
        return EnablementUtil.buildContainerImageNeeded(containerImageConfig, buildRequest) || EnablementUtil.pushContainerImageNeeded(containerImageConfig, pushRequest);
    }
}

