/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.BaseBuildCommand;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.build.BuildSystemRunner;
import io.quarkus.devtools.project.BuildTool;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import picocli.CommandLine;

@CommandLine.Command(name="dev", showEndOfOptionsDelimiterInUsageHelp=true, header={"Run the current project in dev (live coding) mode."})
public class Dev
extends BaseBuildCommand
implements Callable<Integer> {
    @CommandLine.ArgGroup(order=1, exclusive=false, heading="%nDev Mode options:%n")
    DevOptions devOptions = new DevOptions();
    @CommandLine.ArgGroup(order=3, exclusive=false, validate=true, heading="%nDebug options:%n")
    DebugOptions debugOptions = new DebugOptions();
    @CommandLine.Parameters(description={"Parameters passed to the application."})
    List<String> params = new ArrayList<String>();

    @Override
    public Integer call() {
        try {
            this.output.debug("Run project in dev mode with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            BuildSystemRunner runner = this.getRunner();
            List commandArgs = runner.prepareDevTestMode(true, this.devOptions, this.debugOptions, this.params);
            if (this.devOptions.isDryRun()) {
                this.dryRunDev(this.spec.commandLine().getHelp(), runner.getBuildTool(), (BuildSystemRunner.BuildCommandArgs)((Supplier)commandArgs.iterator().next()).get());
                return 0;
            }
            Integer ret = 1;
            for (Supplier i : commandArgs) {
                ret = runner.run((BuildSystemRunner.BuildCommandArgs)i.get());
                if (ret == 0) continue;
                return ret;
            }
            return ret;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to launch project in dev mode: " + e.getMessage());
        }
    }

    void dryRunDev(CommandLine.Help help, BuildTool buildTool, BuildSystemRunner.BuildCommandArgs args) {
        this.output.printText(new String[]{"\nRun current project in dev mode\n", "\t" + this.projectRoot().toString()});
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        dryRunOutput.put("Build tool", buildTool.name());
        this.output.info(help.createTextTable(dryRunOutput).toString());
        this.output.printText(new String[]{"\nCommand line:\n", args.showCommand()});
    }

    public String toString() {
        return "Dev [debugOptions=" + String.valueOf(this.debugOptions) + ", devOptions=" + String.valueOf(this.devOptions) + ", properties=" + String.valueOf(this.propertiesOptions.properties) + ", output=" + String.valueOf(this.output) + ", params=" + String.valueOf(this.params) + "]";
    }
}

