/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.plugin.CliPluginsBase;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginListItem;
import io.quarkus.cli.plugin.PluginListTable;
import io.quarkus.cli.plugin.PluginManager;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="add", header={"Add plugin(s) to the Quarkus CLI."})
public class CliPluginsAdd
extends CliPluginsBase
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;
    @CommandLine.Option(names={"-d", "--description"}, paramLabel="Plugin description", order=5, description={"The plugin description"})
    Optional<String> description;
    @CommandLine.Parameters(arity="1", paramLabel="PLUGIN_NAME", description={" The plugin name or location (e.g. url, path or maven coordinates in GACTV form)"})
    String nameOrLocation;

    @Override
    public Integer call() {
        try {
            this.output.debug("Add plugin with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            if (this.runMode.isDryRun()) {
                this.dryRunAdd(this.spec.commandLine().getHelp());
                return 0;
            }
            return this.addPlugin();
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to add plugin(s): " + this.nameOrLocation + " of type: " + this.type.map(Enum::name).orElse("<any>") + "." + e.getMessage());
        }
    }

    Integer addPlugin() throws IOException {
        PluginManager pluginManager = this.pluginManager();
        String name = pluginManager.getUtil().getName(this.nameOrLocation);
        Optional<Plugin> existingPlugin = Optional.ofNullable((Plugin)pluginManager.getInstalledPlugins().get(name));
        Optional addedPlugin = pluginManager.addPlugin(this.nameOrLocation, this.catalogOptions.user, this.description);
        return addedPlugin.map(plugin -> {
            PluginListTable table = new PluginListTable(List.of(new PluginListItem(true, (Plugin)plugin)), false);
            this.output.info("Added plugin:");
            this.output.info(table.getContent());
            if (plugin.isInProjectCatalog() && existingPlugin.filter(p -> p.isInUserCatalog()).isPresent()) {
                this.output.warn("Plugin was added in the project scope, but another with the same name exists in the user scope!\nThe project scoped one will take precedence when invoked from within the project!");
            }
            if (plugin.isInUserCatalog() && existingPlugin.filter(p -> p.isInProjectCatalog()).isPresent()) {
                this.output.warn("Plugin was added in the user scope, but another with the same name exists in the project scope!\nThe project scoped one will take precedence when invoked from within the project!");
            }
            return 0;
        }).orElseGet(() -> {
            this.output.error("No plugin available at: " + this.nameOrLocation);
            this.printHints(true);
            return 2;
        });
    }

    private void printHints(boolean pluginListHint) {
        if (this.runMode.isBatchMode()) {
            return;
        }
        if (pluginListHint) {
            this.output.info("To see the list of installable plugins, use the 'plugin list' subcommand.");
        }
    }

    void dryRunAdd(CommandLine.Help help) {
        this.output.printText(new String[]{"\nAdd plugin to the CLI\n", "\t" + this.projectRoot().toString()});
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        dryRunOutput.put("Name or Location", this.nameOrLocation);
        this.type.ifPresent(t -> dryRunOutput.put("Type", t.name()));
        this.output.info(help.createTextTable(dryRunOutput).toString());
    }
}

