/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.deploy;

import io.quarkus.cli.common.BuildToolContext;
import io.quarkus.cli.deploy.BaseKubernetesDeployCommand;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="openshift", sortOptions=false, showDefaultValues=true, mixinStandardHelpOptions=false, header={"Perform the deploy action on OpenShift."}, description={"%nThe command will deploy the application on OpenShift."}, footer={"%nFor example (using default values), it will create a Deployment named '<project.artifactId>' using the image with REPOSITORY='${user.name}/<project.artifactId>' and TAG='<project.version>' and will deploy it to the target cluster."}, headerHeading="%n", commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", parameterListHeading="%n", optionListHeading="Options:%n")
public class Openshift
extends BaseKubernetesDeployCommand {
    private static final String OPENSHIFT = "openshift";
    private static final String OPENSHIFT_EXTENSION = "io.quarkus:quarkus-openshift";
    private static final String DEPLOYMENT_KIND = "quarkus.openshift.deployment-kind";
    @CommandLine.Option(names={"--deployment-kind"}, description={"The kind of resource to generate and deploy"})
    public Optional<DeploymentKind> kind;

    @Override
    public void populateContext(BuildToolContext context) {
        super.populateContext(context);
        context.getPropertiesOptions().properties.put(String.format("quarkus.%s.deploy", OPENSHIFT), "true");
        context.getForcedExtensions().add(OPENSHIFT_EXTENSION);
        this.kind.ifPresent(k -> context.getPropertiesOptions().properties.put(DEPLOYMENT_KIND, k.name()));
    }

    @Override
    public String getDefaultImageBuilder() {
        return OPENSHIFT;
    }

    public static enum DeploymentKind {
        Deployment,
        DeploymentConfig,
        StatefulSet,
        Job;

    }
}

