/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.plugin.CliPluginsBase;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginListItem;
import io.quarkus.cli.plugin.PluginListTable;
import io.quarkus.cli.plugin.PluginManager;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="sync", header={"Sync (discover / purge) CLI Plugins."})
public class CliPluginsSync
extends CliPluginsBase
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;

    @Override
    public Integer call() {
        this.output.throwIfUnmatchedArguments(this.spec.commandLine());
        if (this.runMode.isDryRun()) {
            this.dryRunAdd(this.spec.commandLine().getHelp());
            return 0;
        }
        PluginManager pluginManager = this.pluginManager();
        Map before = pluginManager.getInstalledPlugins();
        if (pluginManager.sync()) {
            Map after = pluginManager.getInstalledPlugins();
            Map<String, PluginListItem> installed = after.entrySet().stream().filter(e -> !before.containsKey(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> new PluginListItem(true, (Plugin)e.getValue())));
            Map<String, PluginListItem> uninstalled = before.entrySet().stream().filter(e -> !after.containsKey(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> new PluginListItem(false, (Plugin)e.getValue())));
            HashMap<String, PluginListItem> all = new HashMap<String, PluginListItem>();
            all.putAll(installed);
            all.putAll(uninstalled);
            PluginListTable table = new PluginListTable(all.values(), false, true);
            this.output.info("Sync completed. The following plugins were added/removed:");
            this.output.info(table.getContent());
        } else {
            this.output.info("Nothing to sync (no plugins were added or removed).");
        }
        return 0;
    }

    void dryRunAdd(CommandLine.Help help) {
        this.output.printText(new String[]{"\tSync plugin to the CLI\n", "\t" + this.projectRoot().toString()});
        TreeMap dryRunOutput = new TreeMap();
        this.output.info(help.createTextTable(dryRunOutput).toString());
    }
}

