/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.registry.BaseRegistryCommand;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistryConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="add", header={"Add a Quarkus extension registry"}, description={"%nThis command will add a Quarkus extension registry to the registry client configuration unless it's already present."})
public class RegistryAddCommand
extends BaseRegistryCommand {
    @CommandLine.Parameters(arity="1..*", split=",", paramLabel="REGISTRY-ID[,REGISTRY-ID]", description={"Registry ID to add to the registry client configuration%n  Example:%n    registry.quarkus.io%n    registry.quarkus.acme.com,registry.quarkus.io%n"})
    List<String> registryIds;

    @Override
    public Integer call() throws Exception {
        boolean existingConfig = false;
        Path configYaml = null;
        if (this.registryClient.getConfigArg() != null) {
            configYaml = Paths.get(this.registryClient.getConfigArg(), new String[0]);
            existingConfig = Files.exists(configYaml, new LinkOption[0]);
        }
        RegistriesConfig.Mutable config = configYaml != null && !existingConfig ? RegistriesConfig.builder() : this.registryClient.resolveConfig().mutable();
        this.registryClient.refreshRegistryCache(this.output);
        boolean persist = false;
        for (String registryId : this.registryIds) {
            persist |= config.addRegistry(registryId);
        }
        if (persist) {
            this.output.printText(new String[]{"Configured registries:"});
            for (RegistryConfig rc : config.getRegistries()) {
                if (!existingConfig && config.getRegistries().size() == 1 && !rc.getId().equals("registry.quarkus.io")) {
                    this.output.warn(rc.getId() + " is the only registry configured in the config file.\n" + rc.getId() + " replaced the Default registry: registry.quarkus.io");
                    continue;
                }
                this.output.printText(new String[]{"- " + rc.getId()});
            }
            if (configYaml != null) {
                config.persist(configYaml);
            } else {
                config.persist();
            }
        }
        return 0;
    }
}

