/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import java.util.regex.Pattern;
import picocli.CommandLine;

public class TargetGAVGroup {
    static final String BAD_IDENTIFIER = "The specified %s identifier (%s) contains invalid characters. Valid characters are alphanumeric characters (A-Za-z0-9), underscores, dashes and dots.";
    static final Pattern OK_ID = Pattern.compile("[0-9A-Za-z_.-]+");
    static final String DEFAULT_GAV = "org.acme:code-with-quarkus:1.0.0-SNAPSHOT";
    String groupId = "org.acme";
    String artifactId = "code-with-quarkus";
    String version = "1.0.0-SNAPSHOT";
    @CommandLine.Parameters(arity="0..1", paramLabel="[GROUP-ID:]ARTIFACT-ID[:VERSION]", description={"Java project identifiers%n  default: org.acme:code-with-quarkus:1.0.0-SNAPSHOT%n  Examples:%n     my-project%n     my.group:my-project%n     my.group:my-project:0.1%n"})
    String gav = null;
    boolean initialized = false;

    void projectGav() {
        if (!this.initialized) {
            if (this.gav != null) {
                int firstPos = this.gav.indexOf(":");
                int lastPos = this.gav.lastIndexOf(":");
                if (firstPos < 0) {
                    this.artifactId = this.gav;
                } else {
                    if (firstPos != 0) {
                        this.groupId = this.gav.substring(0, firstPos);
                    }
                    if (lastPos == firstPos) {
                        this.artifactId = this.gav.substring(firstPos + 1);
                    } else if (lastPos >= firstPos + 2) {
                        this.artifactId = this.gav.substring(firstPos + 1, lastPos);
                    }
                    if (lastPos > firstPos && lastPos <= this.gav.length() - 2) {
                        this.version = this.gav.substring(lastPos + 1);
                    }
                }
            }
            if (this.artifactId != "code-with-quarkus" && !OK_ID.matcher(this.artifactId).matches()) {
                throw new CommandLine.TypeConversionException(String.format(BAD_IDENTIFIER, "artifactId", this.artifactId));
            }
            if (this.groupId != "org.acme" && !OK_ID.matcher(this.groupId).matches()) {
                throw new CommandLine.TypeConversionException(String.format(BAD_IDENTIFIER, "groupId", this.groupId));
            }
            this.initialized = true;
        }
    }

    public String getGroupId() {
        this.projectGav();
        return this.groupId;
    }

    public String getArtifactId() {
        this.projectGav();
        return this.artifactId;
    }

    public String getVersion() {
        this.projectGav();
        return this.version;
    }

    public String toString() {
        return "TargetGAVGroup [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", gav=" + this.gav + "]";
    }
}

