/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.devtools.exec.ExecSupport;
import io.quarkus.devtools.exec.Executable;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.smallrye.common.process.ProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class ExecuteUtil {
    private static ExecSupport withOutput(OutputOptionMixin output) {
        return new ExecSupport(output.out(), output.err(), output.isVerbose(), output.isCliTest());
    }

    public static File findExecutableFile(String base) {
        return Executable.findExecutableFile((String)base);
    }

    private static String findExecutable(String exec) {
        return Executable.findExecutable((String)exec);
    }

    public static File findExecutable(String name, String errorMessage, OutputOptionMixin output) {
        return Executable.findExecutable((String)name, (String)errorMessage, (MessageWriter)output);
    }

    public static int executeProcess(OutputOptionMixin output, String[] args, File parentDir) throws IOException, InterruptedException {
        if (output.isVerbose()) {
            output.out().println(String.join((CharSequence)" ", args));
            output.out().println();
        }
        var holder = new Object(){
            int exitCode;
        };
        ProcessBuilder.Input pb = ProcessBuilder.newBuilder((String)args[0]).arguments(List.of(args).subList(1, args.length)).directory(parentDir.toPath()).exitCodeChecker(ec -> {
            holder.exitCode = ec;
            return true;
        }).input().empty();
        if (output.isCliTest()) {
            pb.output().consumeWith(br -> br.lines().forEach(output.out()::println)).error().consumeWith(br -> br.lines().forEach(output.err()::println)).run();
        } else {
            pb.output().inherited().error().inherited().run();
        }
        if (holder.exitCode != 0) {
            return 1;
        }
        return 0;
    }

    public static File findWrapper(Path projectRoot, String[] windows, String other) {
        return Executable.findWrapper((Path)projectRoot, (String[])windows, (String)other);
    }
}

