/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.plugin.CliPluginsBase;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginListItem;
import io.quarkus.cli.plugin.PluginListTable;
import io.quarkus.cli.plugin.PluginManager;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="remove", header={"Remove plugin(s) to the Quarkus CLI."})
public class CliPluginsRemove
extends CliPluginsBase
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;
    @CommandLine.Parameters(arity="1", paramLabel="PLUGIN_NAME", description={"Plugin name to remove from the CLI"})
    String name;

    @Override
    public Integer call() {
        try {
            this.output.debug("Remove plugin with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            if (this.runMode.isDryRun()) {
                this.dryRunRemove(this.spec.commandLine().getHelp());
                return 0;
            }
            return this.removePlugin();
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to remove extension(s): " + e.getMessage());
        }
    }

    Integer removePlugin() throws IOException {
        PluginManager pluginManager = this.pluginManager();
        Optional removedPlugin = pluginManager.removePlugin(this.name, this.catalogOptions.user);
        return removedPlugin.map(plugin -> {
            PluginListTable table = new PluginListTable(List.of(new PluginListItem(false, (Plugin)plugin)), false);
            this.output.info("Removed plugin:");
            this.output.info(table.getContent());
            if (pluginManager.getInstalledPlugins().containsKey(plugin.getName())) {
                if (plugin.isInProjectCatalog()) {
                    this.output.warn("The removed plugin was available both in user and project scopes. It was removed from the project but will remain available in the user scope!");
                } else {
                    this.output.warn("The removed plugin was available both in user and project scopes. It was removed from the user but will remain available in the project scope!");
                }
            }
            return 0;
        }).orElseGet(() -> {
            this.output.error("Plugin: " + this.name + " not found in catalog!");
            return 2;
        });
    }

    void dryRunRemove(CommandLine.Help help) {
        this.output.printText("\nRemove plugin from the CLI\n", "\t" + this.projectRoot().toString());
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        dryRunOutput.put("Plugin to remove", this.name);
        this.output.info(help.createTextTable(dryRunOutput).toString());
    }
}

