/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.Build;
import io.quarkus.cli.CliPlugins;
import io.quarkus.cli.Completion;
import io.quarkus.cli.Config;
import io.quarkus.cli.Create;
import io.quarkus.cli.Deploy;
import io.quarkus.cli.Dev;
import io.quarkus.cli.Image;
import io.quarkus.cli.Info;
import io.quarkus.cli.ProjectExtensions;
import io.quarkus.cli.Registry;
import io.quarkus.cli.Run;
import io.quarkus.cli.Test;
import io.quarkus.cli.Update;
import io.quarkus.cli.Version;
import io.quarkus.cli.common.HelpOption;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.TargetQuarkusPlatformGroup;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCommandFactory;
import io.quarkus.cli.plugin.PluginListItem;
import io.quarkus.cli.plugin.PluginListTable;
import io.quarkus.cli.plugin.PluginManager;
import io.quarkus.cli.plugin.PluginManagerSettings;
import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.utils.Prompt;
import io.quarkus.runtime.QuarkusApplication;
import jakarta.inject.Inject;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="quarkus", subcommands={Create.class, Build.class, Dev.class, Run.class, Test.class, Config.class, ProjectExtensions.class, Image.class, Deploy.class, Registry.class, Info.class, Update.class, Version.class, CliPlugins.class, Completion.class}, scope=CommandLine.ScopeType.INHERIT, sortOptions=false, showDefaultValues=true, versionProvider=Version.class, subcommandsRepeatable=false, mixinStandardHelpOptions=false, commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", optionListHeading="Options:%n", headerHeading="%n", parameterListHeading="%n")
public class QuarkusCli
implements QuarkusApplication,
Callable<Integer> {
    @Inject
    CommandLine.IFactory factory;
    @CommandLine.Mixin
    protected RegistryClientMixin registryClient;
    @CommandLine.Mixin
    protected HelpOption helpOption;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print CLI version information and exit."})
    public boolean showVersion;
    @CommandLine.Mixin(name="output")
    OutputOptionMixin output;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.ArgGroup(exclusive=false, validate=false)
    protected PropertiesOptions propertiesOptions = new PropertiesOptions();

    public OutputOptionMixin getOutput() {
        return this.output;
    }

    public int run(String ... args) throws Exception {
        CommandLine cmd = this.factory == null ? new CommandLine((Object)this) : new CommandLine((Object)this, this.factory);
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        boolean interactiveMode = Arrays.stream(args).noneMatch(arg -> arg.equals("--cli-test"));
        Optional<String> testDir = Arrays.stream(args).dropWhile(arg -> !arg.equals("--cli-test-dir")).skip(1L).findFirst();
        boolean noCommand = args.length == 0 || args[0].startsWith("-");
        boolean helpCommand = Arrays.stream(args).anyMatch(arg -> arg.equals("--help"));
        boolean pluginCommand = args.length >= 1 && (args[0].equals("plug") || args[0].equals("plugin"));
        boolean pluginSyncCommand = pluginCommand && args.length >= 2 && args[1].equals("sync");
        try {
            Optional<String> missingCommand = this.checkMissingCommand(cmd, args);
            boolean existingCommand = missingCommand.isEmpty();
            if (existingCommand && !noCommand && !helpCommand && !pluginCommand) {
                return cmd.execute(args);
            }
            PluginCommandFactory pluginCommandFactory = new PluginCommandFactory(this.output);
            PluginManager pluginManager = this.pluginManager(this.output, testDir, interactiveMode);
            if (!pluginSyncCommand) {
                pluginManager.syncIfNeeded();
            }
            HashMap<String, Plugin> plugins = new HashMap<String, Plugin>(pluginManager.getInstalledPlugins());
            pluginCommandFactory.populateCommands(cmd, plugins);
            missingCommand.filter(m -> !plugins.containsKey(m)).ifPresent(m -> {
                try {
                    this.output.info("Command %s is not available, looking for available plugins ...", new Object[]{m});
                    Map installable = pluginManager.getInstallablePlugins();
                    if (installable.containsKey(m)) {
                        Plugin candidate = (Plugin)installable.get(m);
                        PluginListItem item = new PluginListItem(false, candidate);
                        PluginListTable table = new PluginListTable(List.of(item));
                        this.output.info("Plugin %s is available:\n%s", new Object[]{m, table.getContent()});
                        if (interactiveMode && Prompt.yesOrNo((boolean)true, (String)"Would you like to install it now?", (String[])args)) {
                            pluginManager.addPlugin(m).ifPresent(added -> plugins.put(added.getName(), (Plugin)added));
                            pluginCommandFactory.populateCommands(cmd, plugins);
                        }
                    } else {
                        this.output.error("Command %s is missing and can't be installed.", new Object[]{m});
                    }
                }
                catch (Exception e) {
                    this.output.error("Command %s is missing and can't be installed.", new Object[]{m});
                }
            });
        }
        catch (CommandLine.MutuallyExclusiveArgsException e) {
            return 2;
        }
        return cmd.execute(args);
    }

    public Optional<String> checkMissingCommand(CommandLine root, String[] args) {
        if (args.length == 0) {
            return Optional.empty();
        }
        try {
            CommandLine.ParseResult currentParseResult = root.parseArgs(args);
            StringBuilder missingCommand = new StringBuilder();
            do {
                if (!missingCommand.isEmpty()) {
                    missingCommand.append("-");
                }
                missingCommand.append(currentParseResult.commandSpec().name());
                List unmatchedSubcommands = currentParseResult.unmatched().stream().takeWhile(u -> !u.startsWith("-")).collect(Collectors.toList());
                if (unmatchedSubcommands.isEmpty()) continue;
                missingCommand.append("-").append((String)unmatchedSubcommands.get(0));
                return Optional.of(QuarkusCli.stripRootPrefix(missingCommand.toString(), root.getCommandName() + "-"));
            } while ((currentParseResult = currentParseResult.subcommand()) != null);
            return Optional.empty();
        }
        catch (CommandLine.UnmatchedArgumentException e) {
            return Optional.of(args[0]);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static String stripRootPrefix(String command, String rootPrefix) {
        if (!command.startsWith(rootPrefix)) {
            return command;
        }
        return command.substring(rootPrefix.length());
    }

    @Override
    public Integer call() throws Exception {
        this.output.info("%n@|bold Quarkus CLI|@ version %s", new Object[]{Version.clientVersion()});
        this.output.info("");
        this.output.info("Create Quarkus projects with Maven, Gradle, or JBang.");
        this.output.info("Manage extensions and source registries.");
        this.output.info("");
        this.output.info("Create: @|bold quarkus create|@");
        this.output.info("@|italic Iterate|@: @|bold quarkus dev|@");
        this.output.info("Build and test: @|bold quarkus build|@");
        this.output.info("");
        this.output.info("Find more information at https://quarkus.io");
        this.output.info("If you have questions, check https://github.com/quarkusio/quarkus/discussions");
        this.spec.commandLine().usage(this.output.out());
        this.output.info("");
        this.output.info("Use \"quarkus <command> --help\" for more information about a given command.");
        return this.spec.exitCodeOnUsageHelp();
    }

    private Optional<Path> getProjectRoot(Optional<String> testDir) {
        Path projectRoot = testDir.map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        if (projectRoot == null) {
            projectRoot = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
        }
        return Optional.ofNullable(projectRoot);
    }

    private Supplier<QuarkusProject> quarkusProject(Optional<String> testDir) {
        Path root = this.getProjectRoot(testDir).orElseThrow();
        BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool((Path)root);
        if (buildTool == null) {
            return () -> null;
        }
        return () -> {
            try {
                return this.registryClient.createQuarkusProject(root, new TargetQuarkusPlatformGroup(), buildTool, this.output);
            }
            catch (Exception e) {
                return null;
            }
        };
    }

    private PluginManager pluginManager(OutputOptionMixin output, Optional<String> testDir, boolean interactiveMode) {
        PluginManagerSettings settings = PluginManagerSettings.defaultSettings().withInteractivetMode(interactiveMode);
        return PluginManager.create((PluginManagerSettings)settings, (MessageWriter)output, Optional.ofNullable(Paths.get(System.getProperty("user.home"), new String[0])), this.getProjectRoot(testDir), this.quarkusProject(testDir));
    }

    static {
        System.setProperty("picocli.endofoptions.description", "End of command line options.");
    }

    class SubCommandListRenderer
    implements CommandLine.IHelpSectionRenderer {
        SubCommandListRenderer() {
        }

        public String render(CommandLine.Help help) {
            CommandLine.Model.CommandSpec spec = help.commandSpec();
            if (spec.subcommands().isEmpty()) {
                return "";
            }
            CommandLine.Help.Column commands = new CommandLine.Help.Column(24, 2, CommandLine.Help.Column.Overflow.SPAN);
            CommandLine.Help.Column descriptions = new CommandLine.Help.Column(spec.usageMessage().width() - 24, 2, CommandLine.Help.Column.Overflow.WRAP);
            CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)help.colorScheme(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{commands, descriptions});
            textTable.setAdjustLineBreaksForWideCJKCharacters(spec.usageMessage().adjustLineBreaksForWideCJKCharacters());
            this.addHierarchy(spec.subcommands().values(), textTable, "");
            return textTable.toString();
        }

        private void addHierarchy(Collection<CommandLine> collection, CommandLine.Help.TextTable textTable, String indent) {
            collection.stream().distinct().forEach(subcommand -> {
                String names = String.join((CharSequence)", ", subcommand.getCommandSpec().names());
                String description = this.description(subcommand.getCommandSpec().usageMessage());
                textTable.addRowValues(new String[]{indent + names, description});
                Map subcommands = subcommand.getSubcommands();
                if (!subcommands.isEmpty()) {
                    this.addHierarchy(subcommands.values(), textTable, indent + "  ");
                }
            });
        }

        private String description(CommandLine.Model.UsageMessageSpec usageMessage) {
            if (usageMessage.header().length > 0) {
                return usageMessage.header()[0];
            }
            if (usageMessage.description().length > 0) {
                return usageMessage.description()[0];
            }
            return "";
        }
    }

    class ShortErrorMessageHandler
    implements CommandLine.IParameterExceptionHandler {
        ShortErrorMessageHandler() {
        }

        public int handleParseException(CommandLine.ParameterException ex, String[] args) {
            CommandLine cmd = ex.getCommandLine();
            CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
            QuarkusCli.this.output.error(ex.getMessage());
            QuarkusCli.this.output.printStackTrace((Exception)ex);
            CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)QuarkusCli.this.output.err());
            QuarkusCli.this.output.err().println(cmd.getHelp().fullSynopsis());
            if (spec.equals(spec.root())) {
                QuarkusCli.this.output.err().println(cmd.getHelp().commandList());
            }
            QuarkusCli.this.output.err().printf("See '%s --help' for more information.%n", spec.qualifiedName());
            QuarkusCli.this.output.err().flush();
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : spec.exitCodeOnInvalidInput();
        }
    }
}

