/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.cli.Version;
import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.build.ExecuteUtil;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.CategoryListFormatOptions;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.ListFormatOptions;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.TargetQuarkusVersionGroup;
import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.cli.update.RewriteGroup;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;

public class GradleRunner
implements BuildSystemRunner {
    public static final String[] windowsWrapper = new String[]{"gradlew.cmd", "gradlew.bat"};
    public static final String otherWrapper = "gradlew";
    final OutputOptionMixin output;
    final RegistryClientMixin registryClient;
    final Path projectRoot;
    final BuildTool buildTool;
    final PropertiesOptions propertiesOptions;

    public GradleRunner(OutputOptionMixin output, PropertiesOptions propertiesOptions, RegistryClientMixin registryClient, Path projectRoot, BuildTool buildTool) {
        this.output = output;
        this.projectRoot = projectRoot;
        this.buildTool = buildTool;
        this.propertiesOptions = propertiesOptions;
        this.registryClient = registryClient;
        this.verifyBuildFile();
    }

    @Override
    public File getWrapper() {
        return ExecuteUtil.findWrapper(this.projectRoot, windowsWrapper, otherWrapper);
    }

    @Override
    public File getExecutable() {
        return ExecuteUtil.findExecutable("gradle", "Unable to find the gradle executable, is it in your path?", this.output);
    }

    @Override
    public Path getProjectRoot() {
        return this.projectRoot;
    }

    @Override
    public OutputOptionMixin getOutput() {
        return this.output;
    }

    @Override
    public BuildTool getBuildTool() {
        return this.buildTool;
    }

    @Override
    public Integer listExtensionCategories(RunModeOption runMode, CategoryListFormatOptions format) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("listCategories");
        args.add("--fromCli");
        args.add("--format=" + format.getFormatString());
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer listExtensions(RunModeOption runMode, ListFormatOptions format, boolean installable, String searchPattern, String category) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("listExtensions");
        args.add("--fromCli");
        args.add("--format=" + format.getFormatString());
        if (category != null && !category.isBlank()) {
            args.add("--category=" + category);
        }
        if (!installable) {
            args.add("--installed");
        }
        if (searchPattern != null) {
            args.add("--searchPattern=" + searchPattern);
        }
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer addExtension(RunModeOption runMode, Set<String> extensions) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("addExtension");
        String param = "--extensions=" + String.join((CharSequence)",", extensions);
        args.add(param);
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer removeExtension(RunModeOption runMode, Set<String> extensions) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("removeExtension");
        String param = "--extensions=" + String.join((CharSequence)",", extensions);
        args.add(param);
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer projectInfo(boolean perModule) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        args.add("quarkusInfo");
        if (perModule) {
            args.add("--per-module");
        }
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer updateProject(TargetQuarkusVersionGroup targetQuarkusVersion, RewriteGroup rewrite, boolean perModule) throws Exception {
        ExtensionCatalog extensionCatalog = ToolsUtils.resolvePlatformDescriptorDirectly((String)"io.quarkus", null, (String)Version.clientVersion(), (MavenArtifactResolver)QuarkusProjectHelper.artifactResolver(), (MessageWriter)MessageWriter.info());
        Properties props = ToolsUtils.readQuarkusProperties((ExtensionCatalog)extensionCatalog);
        ArrayDeque<String> args = new ArrayDeque<String>();
        args.add("-PquarkusPluginVersion=" + ToolsUtils.getGradlePluginVersion((Properties)props));
        args.add("--console");
        args.add("plain");
        args.add("--no-daemon");
        args.add("--stacktrace");
        args.add("quarkusUpdate");
        if (!StringUtil.isNullOrEmpty((String)targetQuarkusVersion.platformVersion)) {
            args.add("--platformVersion");
            args.add(targetQuarkusVersion.platformVersion);
        }
        if (!StringUtil.isNullOrEmpty((String)targetQuarkusVersion.streamId)) {
            args.add("--stream");
            args.add(targetQuarkusVersion.streamId);
        }
        if (rewrite.pluginVersion != null) {
            args.add("--rewritePluginVersion=" + rewrite.pluginVersion);
        }
        if (rewrite.quarkusUpdateRecipes != null) {
            args.add("--quarkusUpdateRecipes=" + rewrite.quarkusUpdateRecipes);
        }
        if (rewrite.additionalUpdateRecipes != null) {
            args.add("--additionalUpdateRecipes=" + rewrite.additionalUpdateRecipes);
        }
        if (rewrite.noRewrite) {
            args.add("--noRewrite");
        }
        if (perModule) {
            args.add("--perModule");
        }
        if (rewrite.dryRun) {
            args.add("--rewriteDryRun");
        }
        return this.run(this.prependExecutable(args));
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareBuild(BuildOptions buildOptions, RunModeOption runMode, List<String> params) {
        return this.prepareAction("build", buildOptions, runMode, params);
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareAction(String action, BuildOptions buildOptions, RunModeOption runMode, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        if (buildOptions.clean) {
            args.add("clean");
        }
        args.add(action);
        if (buildOptions.buildNative) {
            args.add("-Dquarkus.native.enabled=true");
            args.add("-Dquarkus.package.jar.enabled=false");
        }
        if (buildOptions.skipTests()) {
            this.setSkipTests(args);
        }
        if (buildOptions.offline) {
            args.add("--offline");
        }
        args.addAll(params);
        return this.prependExecutable(args);
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareTest(BuildOptions buildOptions, RunModeOption runMode, List<String> params, String filter) {
        if (filter != null) {
            params.add("--tests " + filter);
        }
        return this.prepareAction("test", buildOptions, runMode, params);
    }

    @Override
    public List<Supplier<BuildSystemRunner.BuildCommandArgs>> prepareDevTestMode(boolean devMode, DevOptions commonOptions, DebugOptions debugOptions, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        this.setGradleProperties(args, false);
        if (commonOptions.clean) {
            args.add("clean");
        }
        args.add(devMode ? "quarkusDev" : "quarkusTest");
        if (commonOptions.offline) {
            args.add("--offline");
        }
        debugOptions.addDebugArguments(args, jvmArgs);
        this.propertiesOptions.flattenJvmArgs(jvmArgs, args);
        this.paramsToQuarkusArgs(params, args);
        try {
            Path outputFile = Files.createTempFile("quarkus-dev", ".txt", new FileAttribute[0]);
            if (devMode) {
                args.add("-Dio.quarkus.devmode-args=" + String.valueOf(outputFile.toAbsolutePath()));
            }
            BuildSystemRunner.BuildCommandArgs buildCommandArgs = this.prependExecutable(args);
            return Arrays.asList(() -> buildCommandArgs, () -> {
                try {
                    BuildSystemRunner.BuildCommandArgs cmd = new BuildSystemRunner.BuildCommandArgs();
                    cmd.arguments = (String[])Files.readAllLines(outputFile).stream().filter(s -> !s.isBlank()).toArray(String[]::new);
                    cmd.targetDirectory = buildCommandArgs.targetDirectory;
                    return cmd;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void setSkipTests(ArrayDeque<String> args) {
        args.add("-x");
        args.add("test");
    }

    void setGradleProperties(ArrayDeque<String> args, boolean batchMode) {
        String configFile;
        if (this.output.isShowErrors()) {
            args.add("--full-stacktrace");
        }
        if (batchMode) {
            args.add("--console=plain");
        } else if (this.output.isAnsiEnabled()) {
            args.add("--console=rich");
        }
        if (this.output.isCliTest()) {
            args.add("--project-dir=" + String.valueOf(this.projectRoot.toAbsolutePath()));
        }
        args.add(this.registryClient.getRegistryClientProperty());
        String string = configFile = this.registryClient.getConfigArg() == null ? System.getProperty("quarkus.tools.config") : this.registryClient.getConfigArg();
        if (configFile != null) {
            args.add("-Dquarkus.tools.config=" + configFile);
        }
        args.addAll(this.flattenMappedProperties(this.propertiesOptions.properties));
    }

    void verifyBuildFile() {
        for (String buildFileName : this.buildTool.getBuildFiles()) {
            File buildFile = this.projectRoot.resolve(buildFileName).toFile();
            if (!buildFile.exists()) continue;
            return;
        }
        throw new IllegalStateException("Was not able to find a build file in: " + String.valueOf(this.projectRoot) + " based on the following list: " + String.join((CharSequence)",", this.buildTool.getBuildFiles()));
    }
}

