/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.utils;

import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.config.RegistryConfig;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Registries {
    private Registries() {
    }

    public static Set<String> getRegistries(RegistryClientMixin client, String ... additionalRegistires) {
        LinkedHashSet<String> registries = new LinkedHashSet<String>();
        try {
            for (RegistryConfig c : client.resolveConfig().getRegistries()) {
                registries.add(c.getId());
            }
            for (String r : additionalRegistires) {
                registries.add(r);
            }
            return registries;
        }
        catch (RegistryResolutionException e) {
            return new HashSet<String>();
        }
    }
}

