/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.image;

import io.quarkus.cli.BuildToolContext;
import io.quarkus.cli.image.BaseImageSubCommand;
import java.util.Map;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="docker", sortOptions=false, showDefaultValues=true, mixinStandardHelpOptions=false, header={"Build a container image using Docker."}, description={"%nThis command will build or push a container image for the project, using Docker."}, footer={"%nFor example (using default values), it will create a container image using with REPOSITORY='${user.name}/<project.artifactId>' and TAG='<project.version>'."}, headerHeading="%n", commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", parameterListHeading="%n", optionListHeading="Options:%n")
public class Docker
extends BaseImageSubCommand {
    private static final String DOCKER = "docker";
    private static final String DOCKER_CONFIG_PREFIX = "quarkus.docker.";
    private static final String DOCKERFILE_JVM_PATH = "dockerfile-jvm-path";
    private static final String DOCKERFILE_NATIVE_PATH = "dockerfile-native-path";
    @CommandLine.Option(order=7, names={"--dockerfile"}, description={"The path to the Dockerfile."})
    public Optional<String> dockerFile;

    @Override
    public void populateContext(BuildToolContext context) {
        Map<String, String> properties = context.getPropertiesOptions().properties;
        properties.put("quarkus.container-image.builder", DOCKER);
        this.dockerFile.ifPresent(d -> properties.put(DOCKER_CONFIG_PREFIX + (context.getBuildOptions().buildNative ? DOCKERFILE_NATIVE_PATH : DOCKERFILE_JVM_PATH), (String)d));
        context.getForcedExtensions().add("io.quarkus:quarkus-container-image-docker");
    }

    public String toString() {
        return "Docker {imageOptions='" + String.valueOf(this.imageOptions) + "', dockerFile:'" + this.dockerFile.orElse("<none>") + "'}";
    }
}

