/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import java.util.Collection;
import picocli.CommandLine;

public class DebugOptions {
    static final String LOCALHOST = "localhost";
    static final int DEFAULT_PORT = 5005;
    @CommandLine.Option(order=7, names={"--no-debug"}, description={"Toggle debug mode. Enabled by default."}, negatable=true)
    public boolean debug = true;
    @CommandLine.Option(order=8, names={"--debug-host"}, description={"Debug host, e.g. localhost or 0.0.0.0"}, defaultValue="localhost")
    public String host = "localhost";
    @CommandLine.Option(order=9, names={"--debug-mode"}, description={"Valid values: ${COMPLETION-CANDIDATES}.%nEither connect to or listen on <host>:<port>."}, defaultValue="listen")
    public DebugMode mode = DebugMode.listen;
    @CommandLine.Option(order=10, names={"--debug-port"}, description={"Debug port (must be a number > 0)."}, defaultValue="5005")
    public int port = 5005;
    @CommandLine.Option(order=11, names={"--suspend"}, description={"In listen mode, suspend until a debugger is attached. Disabled by default."}, negatable=true)
    public boolean suspend = false;

    public String getJvmDebugParameter() {
        return "-agentlib:jdwp=transport=dt_socket,address=" + this.host + ":" + this.port + ",server=" + (this.mode == DebugMode.listen ? "y" : "n") + ",suspend=" + (this.suspend ? "y" : "n");
    }

    public void addDebugArguments(Collection<String> args, Collection<String> jvmArgs) {
        if (this.debug) {
            if (this.suspend) {
                args.add("-Dsuspend");
            }
            if (!LOCALHOST.equals(this.host)) {
                args.add("-DdebugHost=" + this.host);
            }
            if (this.mode == DebugMode.connect) {
                args.add("-Ddebug=client");
            }
            if (this.port != 5005) {
                args.add("-DdebugPort=" + this.port);
            }
        } else {
            args.add("-Ddebug=false");
        }
    }

    public String toString() {
        return "DebugOptions [debug=" + this.debug + ", mode=" + String.valueOf((Object)this.mode) + ", host=" + this.host + ", port=" + this.port + ", suspend=" + this.suspend + "]";
    }

    public static enum DebugMode {
        connect,
        listen;

    }
}

