/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import java.nio.file.Path;
import java.util.List;

public class BuildToolContext {
    private final Path projectRoot;
    private final RunModeOption runModeOption;
    private final BuildOptions buildOptions;
    private final PropertiesOptions propertiesOptions;
    private final List<String> forcedExtensions;
    private final List<String> params;

    public BuildToolContext(Path projectRoot, RunModeOption runModeOption, BuildOptions buildOptions, PropertiesOptions propertiesOptions, List<String> forcedExtensions, List<String> params) {
        this.projectRoot = projectRoot;
        this.runModeOption = runModeOption;
        this.buildOptions = buildOptions;
        this.propertiesOptions = propertiesOptions;
        this.forcedExtensions = forcedExtensions;
        this.params = params;
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public RunModeOption getRunModeOption() {
        return this.runModeOption;
    }

    public BuildOptions getBuildOptions() {
        return this.buildOptions;
    }

    public PropertiesOptions getPropertiesOptions() {
        return this.propertiesOptions;
    }

    public List<String> getForcedExtensions() {
        return this.forcedExtensions;
    }

    public List<String> getParams() {
        return this.params;
    }

    public BuildTool getBuildTool() {
        return QuarkusProjectHelper.detectExistingBuildTool((Path)this.projectRoot);
    }
}

