/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Deque;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import org.jboss.logging.Logger;

public class DevModeMediator {
    protected static final Logger LOGGER = Logger.getLogger(DevModeMediator.class);
    public static final Deque<List<Path>> removedFiles = new LinkedBlockingDeque<List<Path>>();

    static void doDevMode(Path appRoot) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Path deploymentClassPath = appRoot.resolve("lib/deployment/deployment-class-path.dat");
        Closeable closeable = DevModeMediator.doStart(appRoot, deploymentClassPath);
        Timer timer = new Timer("Classpath Change Timer", false);
        timer.schedule((TimerTask)new ChangeDetector(appRoot, deploymentClassPath, closeable), 1000L, 1000L);
    }

    private static Closeable doStart(Path appRoot, Path deploymentClassPath) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        AppProcessCleanup closeable = null;
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(deploymentClassPath, new OpenOption[0]));){
            List paths = (List)in.readObject();
            URLClassLoader loader = new URLClassLoader((URL[])paths.stream().map(s -> {
                try {
                    return appRoot.resolve((String)s).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new));
            closeable = new AppProcessCleanup((Closeable)loader.loadClass("io.quarkus.deployment.mutability.DevModeTask").getDeclaredMethod("main", Path.class).invoke(null, appRoot), loader);
        }
        return closeable;
    }

    private static class ChangeDetector
    extends TimerTask {
        private final Path appRoot;
        private final Path deploymentClassPath;
        private long lastModified;
        private Closeable closeable;

        public ChangeDetector(Path appRoot, Path deploymentClassPath, Closeable closeable) throws IOException {
            this.appRoot = appRoot;
            this.deploymentClassPath = deploymentClassPath;
            this.closeable = closeable;
            this.lastModified = Files.getLastModifiedTime(deploymentClassPath, new LinkOption[0]).toMillis();
        }

        @Override
        public void run() {
            try {
                long time = Files.getLastModifiedTime(this.deploymentClassPath, new LinkOption[0]).toMillis();
                if (this.lastModified != time) {
                    this.lastModified = time;
                    if (this.closeable != null) {
                        this.closeable.close();
                    }
                    this.closeable = null;
                    List<Path> pathsToDelete = removedFiles.pollFirst();
                    if (pathsToDelete != null) {
                        for (Path p : pathsToDelete) {
                            StringBuilder sb = new StringBuilder().append("Deleting ").append(p);
                            if (!Files.deleteIfExists(p)) {
                                sb.append(" didn't succeed");
                            }
                            LOGGER.info((Object)sb.toString());
                        }
                    }
                    try {
                        this.closeable = DevModeMediator.doStart(this.appRoot, this.deploymentClassPath);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Failed to restart app after classpath changes", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to check for classpath changes", (Throwable)e);
            }
        }
    }

    private static class AppProcessCleanup
    implements Closeable {
        private final Closeable app;
        private final URLClassLoader baseCl;

        public AppProcessCleanup(Closeable app, URLClassLoader baseCl) {
            this.app = app;
            this.baseCl = baseCl;
        }

        @Override
        public void close() throws IOException {
            this.app.close();
            this.baseCl.close();
        }
    }
}

