/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.FailAtCompletionErrorHandler;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTask;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.jboss.logging.Logger;

public class RetryLockAcquisitionErrorHandler
extends FailAtCompletionErrorHandler {
    private static final Logger log = Logger.getLogger(RetryLockAcquisitionErrorHandler.class);
    private final ConcurrentLinkedDeque<ModelResolutionTask> failedTasks = new ConcurrentLinkedDeque();
    private final AtomicBoolean skipRetry = new AtomicBoolean();

    @Override
    public void handleError(ModelResolutionTask task, Exception error) {
        super.handleError(task, error);
        if (this.isRetriableError(error)) {
            this.failedTasks.add(task);
        } else {
            this.skipRetry.set(true);
        }
    }

    @Override
    public void allTasksFinished() {
        if (this.isEmpty()) {
            return;
        }
        if (this.skipRetry.get()) {
            super.allTasksFinished();
        }
        ModelResolutionTaskRunner blockingRunner = ModelResolutionTaskRunner.getBlockingTaskRunner();
        log.warn((Object)"Re-trying dependency resolution tasks previously failed to acquire locks in the local Maven repository");
        for (ModelResolutionTask task : this.failedTasks) {
            blockingRunner.run(task);
        }
    }

    private boolean isRetriableError(Exception error) {
        return RetryLockAcquisitionErrorHandler.isCouldNotAcquireLockError(error) || RetryLockAcquisitionErrorHandler.isMissingFileError(error);
    }

    private static boolean isCouldNotAcquireLockError(Exception error) {
        return error.getLocalizedMessage().contains("Could not acquire ");
    }

    private static boolean isMissingFileError(Exception error) {
        if (!(error instanceof DeploymentInjectionException)) {
            return false;
        }
        Throwable t = error.getCause();
        if (!(t instanceof DependencyCollectionException)) {
            return false;
        }
        while (t != null) {
            Throwable cause = t.getCause();
            if (cause instanceof NoSuchFileException) {
                NoSuchFileException e = (NoSuchFileException)cause;
                return true;
            }
            if (cause instanceof FileNotFoundException) {
                return true;
            }
            t = cause;
        }
        return false;
    }
}

