/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.ModelResolutionTask;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskErrorHandler;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Phaser;

class NonBlockingModelResolutionTaskRunner
implements ModelResolutionTaskRunner {
    private final Phaser phaser = new Phaser(1);
    private final ModelResolutionTaskErrorHandler errorHandler;

    NonBlockingModelResolutionTaskRunner(ModelResolutionTaskErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler cannot be null");
    }

    @Override
    public void run(ModelResolutionTask task) {
        this.phaser.register();
        CompletableFuture.runAsync(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.errorHandler.handleError(task, e);
            }
            finally {
                this.phaser.arriveAndDeregister();
            }
        });
    }

    @Override
    public void waitForCompletion() {
        this.phaser.arriveAndAwaitAdvance();
        this.errorHandler.allTasksFinished();
    }
}

