/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelResolver;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.BootstrapModelCache;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.maven.workspace.WorkspaceModulePom;
import io.quarkus.maven.dependency.GAV;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jboss.logging.Logger;

public class WorkspaceLoader
implements WorkspaceModelResolver,
WorkspaceReader {
    private static final Logger log = Logger.getLogger(WorkspaceLoader.class);
    static final String POM_XML = "pom.xml";
    static final Model MISSING_MODEL = new Model();
    private final Deque<WorkspaceModulePom> moduleQueue = new ConcurrentLinkedDeque<WorkspaceModulePom>();
    private final Map<Path, Model> loadedPoms = new ConcurrentHashMap<Path, Model>();
    private final Map<GAV, Model> loadedModules = new ConcurrentHashMap<GAV, Model>();
    private final Consumer<WorkspaceModulePom> modelProcessor;
    private final LocalWorkspace workspace = new LocalWorkspace();
    private final Path currentProjectPom;
    private volatile LocalProject currentProject;

    static Path getFsRootDir() {
        return Path.of("/", new String[0]);
    }

    static Model readModel(Path pom) {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (NoSuchFileException e) {
            log.warn((Object)("Module(s) under " + String.valueOf(pom.getParent()) + " will be handled as thirdparty dependencies because " + String.valueOf(pom) + " does not exist"));
            return MISSING_MODEL;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load POM from " + String.valueOf(pom), e);
        }
    }

    private static Path locateCurrentProjectPom(Path path) throws BootstrapMavenException {
        for (Path p = path; p != null; p = p.getParent()) {
            Path pom = p.resolve(POM_XML);
            if (!Files.exists(pom, new LinkOption[0])) continue;
            return pom;
        }
        throw new BootstrapMavenException("Failed to locate project pom.xml for " + String.valueOf(path));
    }

    WorkspaceLoader(BootstrapMavenContext ctx, Path currentProjectPom, List<WorkspaceModulePom> providedModules) throws BootstrapMavenException {
        boolean queueCurrentPom;
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(currentProjectPom, BasicFileAttributes.class, new LinkOption[0]);
            this.currentProjectPom = fileAttributes.isDirectory() ? WorkspaceLoader.locateCurrentProjectPom(currentProjectPom) : currentProjectPom;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(currentProjectPom) + " does not exist", e);
        }
        boolean bl = queueCurrentPom = this.currentProjectPom != null;
        if (providedModules != null) {
            for (WorkspaceModulePom e : providedModules) {
                if (queueCurrentPom && this.currentProjectPom.equals(e.pom)) {
                    queueCurrentPom = false;
                }
                this.moduleQueue.push(e);
            }
        }
        if (queueCurrentPom) {
            this.moduleQueue.push(new WorkspaceModulePom(this.currentProjectPom));
        }
        this.modelProcessor = this.getModelProcessor(ctx);
        this.workspace.setBootstrapMavenContext(ctx);
    }

    private void addModulePom(Path pom) {
        if (pom != null) {
            this.moduleQueue.push(new WorkspaceModulePom(pom));
        }
    }

    void setWorkspaceRootPom(Path rootPom) {
        this.addModulePom(rootPom);
    }

    LocalProject load() throws BootstrapMavenException {
        ModelResolutionTaskRunner taskRunner = ModelResolutionTaskRunner.getNonBlockingTaskRunner();
        while (!this.moduleQueue.isEmpty()) {
            ConcurrentLinkedDeque newModules = new ConcurrentLinkedDeque();
            while (!this.moduleQueue.isEmpty()) {
                while (!this.moduleQueue.isEmpty()) {
                    WorkspaceModulePom module = this.moduleQueue.removeLast();
                    taskRunner.run(() -> this.loadModule(module, newModules));
                }
                taskRunner.waitForCompletion();
            }
            for (WorkspaceModulePom newModule : newModules) {
                newModule.process(this.modelProcessor);
            }
        }
        if (this.currentProject == null) {
            throw new BootstrapMavenException("Failed to load project " + String.valueOf(this.currentProjectPom));
        }
        return this.currentProject;
    }

    private Consumer<WorkspaceModulePom> getModelProcessor(BootstrapMavenContext ctx) throws BootstrapMavenException {
        if (ctx == null || !ctx.isEffectiveModelBuilder()) {
            return rawModule -> {
                LocalProject project = new LocalProject(rawModule.getModel(), rawModule.effectiveModel, this.workspace);
                if (this.currentProject == null && project.getDir().equals(this.currentProjectPom.getParent())) {
                    this.currentProject = project;
                }
            };
        }
        ModelBuilder modelBuilder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
        BootstrapModelResolver modelResolver = BootstrapModelResolver.newInstance(ctx, this);
        BootstrapModelCache modelCache = new BootstrapModelCache(modelResolver.getSession());
        List<Profile> profiles = ctx.getActiveSettingsProfiles();
        BootstrapMavenOptions cliOptions = ctx.getCliOptions();
        ArrayList<String> activeProfileIds = new ArrayList<String>(profiles.size() + cliOptions.getActiveProfileIds().size());
        for (Profile p : profiles) {
            activeProfileIds.add(p.getId());
        }
        activeProfileIds.addAll(cliOptions.getActiveProfileIds());
        List<String> inactiveProfileIds = cliOptions.getInactiveProfileIds();
        boolean warnOnFailingWsModules = ctx.isWarnOnFailingWorkspaceModules();
        return rawModule -> {
            LocalProject project;
            DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
            req.setPomFile(rawModule.getModel().getPomFile());
            req.setModelResolver((ModelResolver)modelResolver);
            req.setSystemProperties(System.getProperties());
            req.setUserProperties(System.getProperties());
            req.setModelCache(modelCache);
            req.setActiveProfileIds(activeProfileIds);
            req.setInactiveProfileIds(inactiveProfileIds);
            req.setProfiles(profiles);
            req.setRawModel(rawModule.getModel());
            req.setWorkspaceModelResolver((WorkspaceModelResolver)this);
            try {
                project = new LocalProject(modelBuilder.build((ModelBuildingRequest)req), this.workspace);
            }
            catch (Exception e) {
                if (warnOnFailingWsModules) {
                    log.warn((Object)("Failed to resolve effective model for " + String.valueOf(rawModule.getModel().getPomFile())), (Throwable)e);
                    return;
                }
                throw new RuntimeException("Failed to resolve the effective model for " + String.valueOf(rawModule.getModel().getPomFile()), e);
            }
            if (this.currentProject == null && project.getDir().equals(this.currentProjectPom.getParent())) {
                this.currentProject = project;
            }
            for (String module : project.getEffectiveModel().getModules()) {
                Path modulePath = project.getDir().resolve(module);
                if (Files.isDirectory(modulePath, new LinkOption[0])) {
                    this.addModulePom(modulePath.resolve(POM_XML));
                    continue;
                }
                this.addModulePom(modulePath);
            }
        };
    }

    private void loadModule(WorkspaceModulePom rawModule, Collection<WorkspaceModulePom> newModules) {
        Path parentPom;
        Path moduleDir = rawModule.getModuleDir();
        if (this.loadedPoms.containsKey(moduleDir)) {
            return;
        }
        Model model = rawModule.getModel();
        this.loadedPoms.put(moduleDir, model);
        if (model == MISSING_MODEL) {
            return;
        }
        String rawVersion = ModelUtils.getRawVersion(model);
        String version = ModelUtils.isUnresolvedVersion(rawVersion) ? ModelUtils.resolveVersion(rawVersion, model) : rawVersion;
        Model existingModel = this.loadedModules.putIfAbsent(new GAV(ModelUtils.getGroupId(model), model.getArtifactId(), version), model);
        if (existingModel != null) {
            return;
        }
        newModules.add(rawModule);
        if (!rawVersion.equals(version)) {
            this.loadedModules.putIfAbsent(new GAV(ModelUtils.getGroupId(model), model.getArtifactId(), rawVersion), model);
        }
        for (String module : model.getModules()) {
            this.queueModule(model.getProjectDirectory().toPath().resolve(module));
        }
        for (Profile profile : model.getProfiles()) {
            for (String module : profile.getModules()) {
                this.queueModule(model.getProjectDirectory().toPath().resolve(module));
            }
        }
        if (rawModule.parent == null && (parentPom = rawModule.getParentPom()) != null) {
            Path parentDir = parentPom.getParent();
            if (parentDir == null) {
                parentDir = WorkspaceLoader.getFsRootDir();
            }
            if (!this.loadedPoms.containsKey(parentDir)) {
                rawModule.parent = new WorkspaceModulePom(parentPom);
                this.moduleQueue.push(rawModule.parent);
            }
        }
    }

    private void queueModule(Path module) {
        Path pom;
        Path normalizedModuleDir = module.normalize().toAbsolutePath();
        if (Files.isDirectory(normalizedModuleDir, new LinkOption[0])) {
            pom = normalizedModuleDir.resolve(POM_XML);
        } else {
            pom = normalizedModuleDir;
            Path path = normalizedModuleDir = normalizedModuleDir.getParent() != null ? normalizedModuleDir.getParent() : WorkspaceLoader.getFsRootDir();
        }
        if (!this.loadedPoms.containsKey(normalizedModuleDir)) {
            this.moduleQueue.push(new WorkspaceModulePom(pom));
        }
    }

    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) {
        return this.loadedModules.get(new GAV(groupId, artifactId, versionConstraint));
    }

    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) {
        LocalProject project = this.workspace.getProject(groupId, artifactId);
        return project != null && project.getVersion().equals(versionConstraint) ? project.getEffectiveModel() : null;
    }

    public WorkspaceRepository getRepository() {
        return this.workspace.getRepository();
    }

    public File findArtifact(Artifact artifact) {
        if (!"pom".equals(artifact.getExtension())) {
            return null;
        }
        Model model = this.loadedModules.get(new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        return model == null ? null : model.getPomFile();
    }

    public List<String> findVersions(Artifact artifact) {
        Model model = this.loadedModules.get(new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        return model == null ? List.of() : List.of(ModelUtils.getVersion(model));
    }
}

