/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.update;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.ResolverSetupCleanup;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.fs.util.ZipUtils;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class CreatorOutcomeTestBase
extends ResolverSetupCleanup {
    protected TsArtifact appJar;
    protected boolean createWorkspace;

    protected void createWorkspace() {
        this.createWorkspace = true;
    }

    @BeforeEach
    public void initAppModel() throws Exception {
        this.appJar = this.modelApp();
        this.appJar.install(this.repo);
    }

    @Test
    public void test() throws Exception {
        this.rebuild();
    }

    protected void rebuild() throws Exception {
        Path ws = this.workDir.resolve("workspace");
        IoUtils.recursiveDelete((Path)ws);
        Path outputDir = IoUtils.mkdirs((Path)ws.resolve("target"));
        Path applicationRoot = this.resolver.resolve(this.appJar.toArtifact()).getResolvedPaths().getSinglePath();
        QuarkusBootstrap.Builder bootstrap = QuarkusBootstrap.builder().setApplicationRoot(applicationRoot).setProjectRoot(applicationRoot).setTargetDirectory(outputDir).setAppModelResolver((AppModelResolver)this.resolver).setTest(this.isBootstrapForTestMode());
        if (this.createWorkspace) {
            System.setProperty("basedir", ws.toAbsolutePath().toString());
            Path classesDir = outputDir.resolve("classes");
            ZipUtils.unzip((Path)applicationRoot, (Path)classesDir);
            ModelUtils.persistModel((Path)ws.resolve("pom.xml"), (Model)this.appJar.getPomModel());
            bootstrap.setProjectRoot(ws);
            bootstrap.setLocalProjectDiscovery(Boolean.valueOf(true));
            bootstrap.setAppModelResolver((AppModelResolver)this.initResolver(LocalProject.loadWorkspace((Path)classesDir)));
        }
        this.initProps(bootstrap);
        try {
            this.testCreator(bootstrap.build());
        }
        catch (Exception e) {
            this.assertError(e);
        }
    }

    protected void assertError(Exception e) throws Exception {
        throw e;
    }

    protected abstract TsArtifact modelApp() throws Exception;

    protected abstract void testCreator(QuarkusBootstrap var1) throws Exception;

    protected void initProps(QuarkusBootstrap.Builder builder) {
    }
}

