/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsJar;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.bootstrap.resolver.TsRepoBuilder;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class ResolverSetupCleanup {
    protected Path workDir;
    protected Path repoHome;
    protected BootstrapAppModelResolver resolver;
    protected TsRepoBuilder repo;
    protected Properties originalProps;

    @BeforeEach
    public void setup() throws Exception {
        this.workDir = this.initWorkDir();
        this.repoHome = IoUtils.mkdirs((Path)this.workDir.resolve("repo"));
        this.resolver = this.initResolver(null);
        this.repo = TsRepoBuilder.getInstance(this.resolver, this.workDir);
    }

    @AfterEach
    public void cleanup() {
        if (this.cleanWorkDir() && this.workDir != null) {
            IoUtils.recursiveDelete((Path)this.workDir);
        }
        if (this.originalProps != null) {
            System.setProperties(this.originalProps);
        }
    }

    protected void setSystemProperty(String name, String value) {
        if (this.originalProps == null) {
            this.originalProps = new Properties(System.getProperties());
        }
        System.setProperty(name, value);
    }

    protected Path initWorkDir() {
        return IoUtils.createRandomTmpDir();
    }

    protected boolean cleanWorkDir() {
        return true;
    }

    protected boolean isBootstrapForTestMode() {
        return false;
    }

    protected BootstrapAppModelResolver initResolver(LocalProject currentProject) throws Exception {
        BootstrapAppModelResolver appModelResolver = new BootstrapAppModelResolver(((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setLocalRepository(this.repoHome.toString())).setOffline(true)).setWorkspaceDiscovery(false)).setCurrentProject(currentProject)).build());
        if (this.isBootstrapForTestMode()) {
            appModelResolver.setTest(true);
        }
        return appModelResolver;
    }

    protected TsJar newJar() throws IOException {
        return new TsJar(this.workDir.resolve(UUID.randomUUID().toString()));
    }

    protected TsQuarkusExt install(TsQuarkusExt extension) {
        extension.install(this.repo);
        return extension;
    }

    protected TsArtifact install(TsArtifact artifact) {
        this.repo.install(artifact);
        return artifact;
    }

    protected TsArtifact install(TsArtifact artifact, Path p) {
        this.repo.install(artifact, p);
        return artifact;
    }
}

