/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.PropsBuilder;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsJar;
import io.quarkus.bootstrap.resolver.TsRepoBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class TsQuarkusExt {
    protected final TsArtifact runtime;
    protected final TsArtifact deployment;
    protected final List<TsQuarkusExt> extDeps = new ArrayList<TsQuarkusExt>(0);
    protected final TsJar rtContent;
    protected final PropsBuilder rtDescr = PropsBuilder.newInstance();
    private boolean installed;

    public TsQuarkusExt(String artifactId) {
        this(artifactId, "1");
    }

    public TsQuarkusExt(String artifactId, String version) {
        this.runtime = TsArtifact.jar(artifactId, version);
        this.deployment = TsArtifact.jar(artifactId + "-deployment", version);
        this.deployment.addDependency(this.runtime);
        this.rtContent = new TsJar();
        this.runtime.setContent(this.rtContent);
        this.rtDescr.set("deployment-artifact", this.deployment.toString());
    }

    public TsQuarkusExt setConditionalDeps(TsQuarkusExt ... exts) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        buf.append(exts[i++].getRuntime().toString());
        while (i < exts.length) {
            buf.append(' ').append(exts[i++].getRuntime().toString());
        }
        return this.setDescriptorProp("conditional-dependencies", buf.toString());
    }

    public TsQuarkusExt setDependencyCondition(TsQuarkusExt ... exts) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        buf.append(exts[i++].getRuntime().getKey());
        while (i < exts.length) {
            buf.append(' ').append(exts[i++].getRuntime().getKey());
        }
        return this.setDescriptorProp("dependency-condition", buf.toString());
    }

    public TsQuarkusExt setDescriptorProp(String name, String value) {
        this.rtDescr.set(name, value);
        return this;
    }

    public TsQuarkusExt setProvidesCapabilities(String ... capability) {
        this.setDescriptorProp("provides-capabilities", Arrays.asList(capability).stream().collect(Collectors.joining(",")));
        return this;
    }

    public TsArtifact getRuntime() {
        return this.runtime;
    }

    public TsArtifact getDeployment() {
        return this.deployment;
    }

    public TsQuarkusExt addDependency(TsQuarkusExt ext, TsArtifact ... exclusions) {
        this.extDeps.add(ext);
        this.runtime.addDependency(ext.runtime, exclusions);
        this.deployment.addDependency(ext.deployment);
        return this;
    }

    public void install(TsRepoBuilder repo) {
        if (this.installed) {
            return;
        }
        this.installed = true;
        this.rtContent.addEntry(this.rtDescr.build(), "META-INF/quarkus-extension.properties");
        if (!this.extDeps.isEmpty()) {
            for (TsQuarkusExt e : this.extDeps) {
                e.install(repo);
            }
        }
        Properties props = this.rtDescr.build();
        this.rtContent.addEntry(props, "META-INF/quarkus-extension.properties");
        this.deployment.install(repo);
        this.runtime.install(repo);
    }
}

