/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class PropertyUtils {
    private static final String OS_NAME = "os.name";
    private static final String USER_HOME = "user.home";
    private static final String WINDOWS = "windows";
    private static final String FALSE = "false";
    private static final String TRUE = "true";

    private PropertyUtils() {
    }

    public static boolean isWindows() {
        return PropertyUtils.getProperty(OS_NAME).toLowerCase(Locale.ENGLISH).indexOf(WINDOWS) >= 0;
    }

    public static String getUserHome() {
        return PropertyUtils.getProperty(USER_HOME);
    }

    public static String getProperty(final String name, final String defValue) {
        assert (name != null) : "name is null";
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name, defValue);
                }
            });
        }
        return System.getProperty(name, defValue);
    }

    public static String getProperty(final String name) {
        assert (name != null) : "name is null";
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }
        return System.getProperty(name);
    }

    public static final Boolean getBooleanOrNull(String name) {
        String value = PropertyUtils.getProperty(name);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static final boolean getBoolean(String name, boolean notFoundValue) {
        String value = PropertyUtils.getProperty(name, notFoundValue ? TRUE : FALSE);
        return value.isEmpty() ? true : Boolean.parseBoolean(value);
    }
}

